/*
 * Decompiled with CFR 0.152.
 */
package mapwriter.region;

import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import mapwriter.region.IChunk;
import mapwriter.region.Nbt;
import mapwriter.region.RegionFile;
import mapwriter.region.RegionFileCache;
import mapwriter.region.RegionManager;

public class MwChunk
implements IChunk {
    public static final int SIZE = 16;
    public final int x;
    public final int z;
    public final int dimension;
    public final byte[][] msbArray;
    public final byte[][] lsbArray;
    public final byte[][] metaArray;
    public final byte[][] lightingArray;
    public final byte[] biomeArray;
    public final int maxY;

    public MwChunk(int x, int z, int dimension, byte[][] msbArray, byte[][] lsbArray, byte[][] metaArray, byte[][] lightingArray, byte[] biomeArray) {
        this.x = x;
        this.z = z;
        this.dimension = dimension;
        this.msbArray = msbArray;
        this.lsbArray = lsbArray;
        this.metaArray = metaArray;
        this.biomeArray = biomeArray;
        this.lightingArray = lightingArray;
        int maxY = 0;
        for (int y = 0; y < 16; ++y) {
            if (lsbArray[y] == null) continue;
            maxY = (y << 4) + 15;
        }
        this.maxY = maxY;
    }

    public String toString() {
        return String.format("(%d, %d) dim%d", this.x, this.z, this.dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MwChunk read(int x, int z, int dimension, RegionFileCache regionFileCache) {
        byte[][] lightingArray;
        byte[][] metaArray;
        byte[][] lsbArray;
        byte[][] msbArray;
        byte[] biomeArray;
        block15: {
            biomeArray = null;
            msbArray = new byte[16][];
            lsbArray = new byte[16][];
            metaArray = new byte[16][];
            lightingArray = new byte[16][];
            FilterInputStream dis = null;
            RegionFile regionFile = regionFileCache.getRegionFile(x << 4, z << 4, dimension);
            if (!regionFile.isOpen() && regionFile.exists()) {
                regionFile.open();
            }
            if (regionFile.isOpen()) {
                dis = regionFile.getChunkDataInputStream(x & 0x1F, z & 0x1F);
            }
            if (dis != null) {
                Nbt root = Nbt.readNextElement(dis);
                Nbt level = root.getChild("Level");
                int xNbt = level.getChild("xPos").getInt();
                int zNbt = level.getChild("zPos").getInt();
                if (xNbt != x || zNbt != z) {
                    RegionManager.logWarning("chunk (%d, %d) has NBT coords (%d, %d)", x, z, xNbt, zNbt);
                }
                Nbt sections = level.getChild("Sections");
                for (int i = 0; i < sections.size(); ++i) {
                    Nbt section = sections.getChild(i);
                    if (section.isNull()) continue;
                    byte y = section.getChild("Y").getByte();
                    lsbArray[y & 0xF] = section.getChild("Blocks").getByteArray();
                    msbArray[y & 0xF] = section.getChild("Add").getByteArray();
                    metaArray[y & 0xF] = section.getChild("Data").getByteArray();
                }
                biomeArray = level.getChild("Biomes").getByteArray();
                try {
                    dis.close();
                }
                catch (IOException e) {
                    RegionManager.logError("MwChunk.read: %s while closing input stream", e);
                }
                break block15;
                catch (IOException e) {
                    try {
                        RegionManager.logError("%s: could not read chunk (%d, %d) from region file\n", e, x, z);
                    }
                    catch (Throwable throwable) {
                        try {
                            dis.close();
                        }
                        catch (IOException e2) {
                            RegionManager.logError("MwChunk.read: %s while closing input stream", e2);
                        }
                        throw throwable;
                    }
                    try {
                        dis.close();
                    }
                    catch (IOException e3) {
                        RegionManager.logError("MwChunk.read: %s while closing input stream", e3);
                    }
                }
            }
        }
        return new MwChunk(x, z, dimension, msbArray, lsbArray, metaArray, lightingArray, biomeArray);
    }

    public boolean isEmpty() {
        return this.maxY <= 0;
    }

    @Override
    public int getBiome(int x, int z) {
        return this.biomeArray != null ? this.biomeArray[(z & 0xF) << 4 | x & 0xF] & 0xFF : 0;
    }

    @Override
    public int getLightValue(int x, int y, int z) {
        return 15;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getBlockAndMetadata(int x, int y, int z) {
        int yi = y >> 4 & 0xF;
        int offset = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
        byte lsb = this.lsbArray != null && this.lsbArray[yi] != null ? this.lsbArray[yi][offset] : (byte)0;
        byte msb = this.msbArray != null && this.msbArray[yi] != null ? this.msbArray[yi][offset >> 1] : (byte)0;
        byte meta = this.metaArray != null && this.metaArray[yi] != null ? this.metaArray[yi][offset >> 1] : (byte)0;
        return (offset & 1) == 1 ? (msb & 0xF0) << 8 | (lsb & 0xFF) << 4 | (meta & 0xF0) >> 4 : (msb & 0xF) << 12 | (lsb & 0xFF) << 4 | meta & 0xF;
    }

    public Nbt getNbt() {
        Nbt sections = new Nbt(9, "Sections", null);
        for (int y = 0; y < 16; ++y) {
            Nbt section = new Nbt(10, "", null);
            section.addChild(new Nbt(1, "Y", (byte)y));
            if (this.lsbArray != null && this.lsbArray[y] != null) {
                section.addChild(new Nbt(7, "Blocks", this.lsbArray[y]));
            }
            if (this.msbArray != null && this.msbArray[y] != null) {
                section.addChild(new Nbt(7, "Add", this.msbArray[y]));
            }
            if (this.metaArray != null && this.metaArray[y] != null) {
                section.addChild(new Nbt(7, "Data", this.metaArray[y]));
            }
            sections.addChild(section);
        }
        Nbt level = new Nbt(10, "Level", null);
        level.addChild(new Nbt(3, "xPos", this.x));
        level.addChild(new Nbt(3, "zPos", this.z));
        level.addChild(sections);
        if (this.biomeArray != null) {
            level.addChild(new Nbt(7, "Biomes", this.biomeArray));
        }
        Nbt root = new Nbt(10, "", null);
        root.addChild(level);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean write(RegionFileCache regionFileCache) {
        boolean error;
        block11: {
            block12: {
                block13: {
                    error = false;
                    RegionFile regionFile = regionFileCache.getRegionFile(this.x << 4, this.z << 4, this.dimension);
                    if (!regionFile.isOpen()) {
                        error = regionFile.open();
                    }
                    if (error) break block12;
                    DataOutputStream dos = regionFile.getChunkDataOutputStream(this.x & 0x1F, this.z & 0x1F);
                    if (dos == null) break block13;
                    Nbt chunkNbt = this.getNbt();
                    chunkNbt.writeElement(dos);
                    try {
                        dos.close();
                    }
                    catch (IOException e) {
                        RegionManager.logError("%s while closing chunk data output stream", e);
                    }
                    break block11;
                    catch (IOException e) {
                        try {
                            RegionManager.logError("%s: could not write chunk (%d, %d) to region file", e, this.x, this.z);
                            error = true;
                        }
                        catch (Throwable throwable) {
                            try {
                                dos.close();
                            }
                            catch (IOException e2) {
                                RegionManager.logError("%s while closing chunk data output stream", e2);
                            }
                            throw throwable;
                        }
                        try {
                            dos.close();
                        }
                        catch (IOException e3) {
                            RegionManager.logError("%s while closing chunk data output stream", e3);
                        }
                        break block11;
                    }
                }
                RegionManager.logError("error: could not get output stream for chunk (%d, %d)", this.x, this.z);
                break block11;
            }
            RegionManager.logError("error: could not open region file for chunk (%d, %d)", this.x, this.z);
        }
        return error;
    }
}

