/*
 * Decompiled with CFR 0.152.
 */
package io.nettyopis.handler.codec.socks;

import io.nettyopis.buffer.ByteBuf;
import io.nettyopis.channel.ChannelHandlerContext;
import io.nettyopis.handler.codec.ReplayingDecoder;
import io.nettyopis.handler.codec.socks.SocksAuthScheme;
import io.nettyopis.handler.codec.socks.SocksCommonUtils;
import io.nettyopis.handler.codec.socks.SocksInitResponse;
import io.nettyopis.handler.codec.socks.SocksProtocolVersion;
import io.nettyopis.handler.codec.socks.SocksResponse;
import java.util.List;

public class SocksInitResponseDecoder
extends ReplayingDecoder<State> {
    private static final String name = "SOCKS_INIT_RESPONSE_DECODER";
    private SocksProtocolVersion version;
    private SocksAuthScheme authScheme;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    @Deprecated
    public static String getName() {
        return name;
    }

    public SocksInitResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksProtocolVersion.valueOf(byteBuf.readByte());
                if (this.version != SocksProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_PREFFERED_AUTH_TYPE);
            }
            case READ_PREFFERED_AUTH_TYPE: {
                this.authScheme = SocksAuthScheme.valueOf(byteBuf.readByte());
                this.msg = new SocksInitResponse(this.authScheme);
            }
        }
        ctx.pipeline().remove(this);
        out.add(this.msg);
    }

    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_PREFFERED_AUTH_TYPE;

    }
}

