/*
 * Decompiled with CFR 0.152.
 */
package io.nettyopis.handler.codec.serialization;

import io.nettyopis.buffer.ByteBuf;
import io.nettyopis.buffer.ByteBufOutputStream;
import io.nettyopis.channel.ChannelHandler;
import io.nettyopis.channel.ChannelHandlerContext;
import io.nettyopis.handler.codec.MessageToByteEncoder;
import io.nettyopis.handler.codec.serialization.CompactObjectOutputStream;
import java.io.Serializable;

@ChannelHandler.Sharable
public class ObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];

    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        int startIdx = out.writerIndex();
        ByteBufOutputStream bout = new ByteBufOutputStream(out);
        bout.write(LENGTH_PLACEHOLDER);
        CompactObjectOutputStream oout = new CompactObjectOutputStream(bout);
        oout.writeObject(msg);
        oout.flush();
        oout.close();
        int endIdx = out.writerIndex();
        out.setInt(startIdx, endIdx - startIdx - 4);
    }
}

