/*
 * Decompiled with CFR 0.152.
 */
package io.nettyopis.handler.codec.protobuf;

import com.google.protobuf.CodedOutputStream;
import io.nettyopis.buffer.ByteBuf;
import io.nettyopis.buffer.ByteBufOutputStream;
import io.nettyopis.channel.ChannelHandler;
import io.nettyopis.channel.ChannelHandlerContext;
import io.nettyopis.handler.codec.MessageToByteEncoder;
import java.io.OutputStream;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int bodyLen = msg.readableBytes();
        int headerLen = CodedOutputStream.computeRawVarint32Size((int)bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        CodedOutputStream headerOut = CodedOutputStream.newInstance((OutputStream)new ByteBufOutputStream(out), (int)headerLen);
        headerOut.writeRawVarint32(bodyLen);
        headerOut.flush();
        out.writeBytes(msg, msg.readerIndex(), bodyLen);
    }
}

