/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.registries;

import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.ENBlocks;
import exnihilo.ENItems;
import exnihilo.registries.helpers.Smashable;
import exnihilo.utils.ItemInfo;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class HammerRegistry {
    private static HashMap<ItemInfo, ArrayList<Smashable>> rewards = new HashMap();
    public static boolean allowIceShards = true;
    public static String categorySmashableOptions = "smashables";

    public static void register(Block source, int sourceMeta, Item output, int outputMeta, float chance, float luckMultiplier) {
        Smashable entry = new Smashable(source, sourceMeta, output, outputMeta, chance, luckMultiplier);
        ItemInfo ii = new ItemInfo(source, sourceMeta);
        ArrayList<Object> current = rewards.containsKey(ii) ? rewards.get(ii) : new ArrayList();
        current.add(entry);
        rewards.put(ii, current);
    }

    public static ArrayList<Smashable> getRewards(Block block, int meta) {
        return rewards.get(new ItemInfo(block, meta));
    }

    public static void load(Configuration config) {
        allowIceShards = config.get(categorySmashableOptions, "allowIceShards", true).getBoolean();
        if (allowIceShards) {
            HammerRegistry.register(Blocks.field_150432_aD, 0, ENItems.IceShard, 0, 1.0f, 0.0f);
            HammerRegistry.register(Blocks.field_150432_aD, 0, ENItems.IceShard, 0, 0.75f, 0.1f);
            HammerRegistry.register(Blocks.field_150432_aD, 0, ENItems.IceShard, 0, 0.75f, 0.1f);
            HammerRegistry.register(Blocks.field_150432_aD, 0, ENItems.IceShard, 0, 0.5f, 0.1f);
            HammerRegistry.register(Blocks.field_150432_aD, 0, ENItems.IceShard, 0, 0.25f, 0.1f);
            HammerRegistry.register(Blocks.field_150432_aD, 0, ENItems.IceShard, 0, 0.05f, 0.1f);
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150403_cj), new Object[]{"a a", " b ", "a a", Character.valueOf('a'), new ItemStack(ENItems.IceShard), Character.valueOf('b'), new ItemStack((Block)Blocks.field_150354_m)}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Blocks.field_150432_aD), new Object[]{"aa", "aa", Character.valueOf('a'), new ItemStack(ENItems.IceShard)}));
        }
    }

    public static boolean registeredInefficiently(Block block, int meta) {
        for (Smashable reward : rewards.get(new ItemInfo(block, meta))) {
            if (!reward.source.func_149739_a().equals(block.func_149739_a()) || reward.meta != meta) continue;
            return true;
        }
        return false;
    }

    public static boolean registered(ItemStack item) {
        return rewards.containsKey(new ItemInfo(item));
    }

    public static boolean registered(Block block, int meta) {
        return HammerRegistry.registered(new ItemStack(block, 1, meta));
    }

    public static void registerSmashables() {
        HammerRegistry.register(Blocks.field_150348_b, 0, ENItems.Stones, 0, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150348_b, 0, ENItems.Stones, 0, 0.75f, 0.1f);
        HammerRegistry.register(Blocks.field_150348_b, 0, ENItems.Stones, 0, 0.75f, 0.1f);
        HammerRegistry.register(Blocks.field_150348_b, 0, ENItems.Stones, 0, 0.5f, 0.1f);
        HammerRegistry.register(Blocks.field_150348_b, 0, ENItems.Stones, 0, 0.25f, 0.1f);
        HammerRegistry.register(Blocks.field_150348_b, 0, ENItems.Stones, 0, 0.05f, 0.1f);
        HammerRegistry.register(Blocks.field_150347_e, 0, Item.func_150898_a((Block)Blocks.field_150351_n), 0, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150351_n, 0, Item.func_150898_a((Block)Blocks.field_150354_m), 0, 1.0f, 0.0f);
        HammerRegistry.register((Block)Blocks.field_150354_m, 0, Item.func_150898_a((Block)ENBlocks.Dust), 0, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150322_A, 0, Item.func_150898_a((Block)Blocks.field_150354_m), 0, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150322_A, 1, Item.func_150898_a((Block)Blocks.field_150354_m), 0, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150322_A, 2, Item.func_150898_a((Block)Blocks.field_150354_m), 0, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150417_aV, 0, Item.func_150898_a((Block)Blocks.field_150417_aV), 2, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150417_aV, 2, ENItems.Stones, 0, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150417_aV, 2, ENItems.Stones, 0, 0.75f, 0.1f);
        HammerRegistry.register(Blocks.field_150417_aV, 2, ENItems.Stones, 0, 0.75f, 0.1f);
        HammerRegistry.register(Blocks.field_150417_aV, 2, ENItems.Stones, 0, 0.5f, 0.1f);
        HammerRegistry.register(Blocks.field_150417_aV, 2, ENItems.Stones, 0, 0.25f, 0.1f);
        HammerRegistry.register(Blocks.field_150417_aV, 2, ENItems.Stones, 0, 0.05f, 0.1f);
        HammerRegistry.register(Blocks.field_150377_bs, 0, Item.func_150898_a((Block)ENBlocks.EnderGravel), 0, 1.0f, 0.0f);
        HammerRegistry.register(Blocks.field_150424_aL, 0, Item.func_150898_a((Block)ENBlocks.NetherGravel), 0, 1.0f, 0.0f);
    }

    public static void registerOre(Block ore, int oreMeta, Item reward, int rewardMeta) {
        if (ore != null && reward != null) {
            HammerRegistry.register(ore, oreMeta, reward, rewardMeta, 1.0f, 0.0f);
            HammerRegistry.register(ore, oreMeta, reward, rewardMeta, 1.0f, 0.0f);
            HammerRegistry.register(ore, oreMeta, reward, rewardMeta, 1.0f, 0.0f);
            HammerRegistry.register(ore, oreMeta, reward, rewardMeta, 1.0f, 0.0f);
            HammerRegistry.register(ore, oreMeta, reward, rewardMeta, 0.5f, 0.1f);
            HammerRegistry.register(ore, oreMeta, reward, rewardMeta, 0.05f, 0.1f);
            HammerRegistry.register(ore, oreMeta, reward, rewardMeta, 0.0f, 0.05f);
        }
    }

    public static ArrayList<ItemInfo> getSources(ItemStack reward) {
        ArrayList<ItemInfo> res = new ArrayList<ItemInfo>();
        for (ItemInfo entry : rewards.keySet()) {
            for (Smashable smash : rewards.get(entry)) {
                if (!new ItemInfo(smash.item, smash.meta).equals(new ItemInfo(reward))) continue;
                res.add(entry);
            }
        }
        return res;
    }
}

