/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs.turret;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import toast.utilityMobs.EnumUpgrade;
import toast.utilityMobs.ai.EntityAIGolemTarget;
import toast.utilityMobs.ai.EntityAITurretAttack;
import toast.utilityMobs.golem.EntityUtilityGolem;

public class EntityTurretGolem
extends EntityUtilityGolem {
    public static final EnumUpgrade[] upgradesAll = new EnumUpgrade[]{EnumUpgrade.KILLER, EnumUpgrade.FIRE, EnumUpgrade.FEATHER, EnumUpgrade.SLOW, EnumUpgrade.EGG, EnumUpgrade.SIGHT, EnumUpgrade.EXPLOSIVE, EnumUpgrade.POISON, EnumUpgrade.FIRE_EXPLOSIVE};
    private static final UUID sightBoostUUID = UUID.fromString("70A27B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier sightBoost = new AttributeModifier(sightBoostUUID, "Ender pearl upgrade", 10.0, 0).func_111168_a(false);
    public EnumUpgrade[] upgrades = new EnumUpgrade[]{EnumUpgrade.KILLER, EnumUpgrade.FIRE, EnumUpgrade.FEATHER, EnumUpgrade.SLOW, EnumUpgrade.EGG, EnumUpgrade.SIGHT, EnumUpgrade.EXPLOSIVE, EnumUpgrade.POISON, EnumUpgrade.FIRE_EXPLOSIVE};
    public EntityAIGolemTarget targetAI = new EntityAIGolemTarget(this);
    public EnumUpgrade upgrade;
    public int maxAttackTime = 60;

    public EntityTurretGolem(World world) {
        super(world);
        this.field_82174_bp[0] = 2.0f;
        this.sinks = 1;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITurretAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.targetAI);
        this.updateTurretStats();
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
    }

    public void func_70091_d(double x, double y, double z) {
        if (this.func_71124_b(0) != null && this.func_71124_b(0).func_77973_b() == Items.field_151008_G) {
            super.func_70091_d(x, y, z);
        } else {
            super.func_70091_d(0.0, y, 0.0);
        }
    }

    public double func_70033_W() {
        return super.func_70033_W() - (double)this.field_70131_O / 4.0;
    }

    @Override
    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150367_z);
    }

    @Override
    protected void dropFewItems(boolean recentlyHit, int looting, float dropChance) {
        if (this.field_70146_Z.nextFloat() < dropChance / 2.0f + 0.3f) {
            this.func_145779_a(this.func_146068_u(), 1);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (!this.canInteract(player)) {
            return super.func_70085_c(player);
        }
        ItemStack playerHeld = player.func_71124_b(0);
        if (playerHeld == null) {
            if (this.func_71124_b(0) != null) {
                player.func_70062_b(0, this.func_71124_b(0));
                this.func_70062_b(0, null);
                player.func_71038_i();
                return true;
            }
        } else {
            if (EnumUpgrade.getUpgrade(this.upgrades, playerHeld) != EnumUpgrade.DEFAULT) {
                player.func_71038_i();
                ItemStack heldItem = this.func_71124_b(0);
                if (heldItem != null && playerHeld == heldItem) {
                    this.func_85030_a("note.bass", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70062_b(0, playerHeld.func_77946_l());
                    this.func_71124_b((int)0).field_77994_a = 1;
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --playerHeld.field_77994_a;
                }
                if (playerHeld.field_77994_a <= 0) {
                    player.func_70062_b(0, heldItem);
                } else if (!this.field_70170_p.field_72995_K && heldItem != null && !player.field_71075_bZ.field_75098_d) {
                    this.func_70099_a(heldItem, 0.0f);
                }
                this.func_85030_a("note.pling", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                this.func_70656_aK();
                return true;
            }
            if (EnumUpgrade.getUpgrade(upgradesAll, playerHeld) != EnumUpgrade.DEFAULT) {
                this.func_85030_a("note.bass", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                player.func_71038_i();
                return true;
            }
        }
        return super.func_70085_c(player);
    }

    @Override
    public int getUsePermissions() {
        return super.getUsePermissions() | 4;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.updateTurretStats();
    }

    public void func_70062_b(int index, ItemStack itemStack) {
        super.func_70062_b(index, itemStack);
        if (index == 0) {
            this.updateTurretStats();
        }
    }

    public void updateTurretStats() {
        IAttributeInstance range = this.func_110148_a(SharedMonsterAttributes.field_111265_b);
        range.func_111124_b(sightBoost);
        this.upgrade = EnumUpgrade.getUpgrade(this.upgrades, this.func_71124_b(0));
        if (this.upgrade == EnumUpgrade.SIGHT) {
            range.func_111121_a(sightBoost);
        }
    }

    @Override
    public void doRangedAttack(EntityLivingBase target) {
        if (!this.field_70170_p.field_72995_K) {
            EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, 12.0f);
            this.targetHelper.setOwned((Entity)arrow);
            this.upgrade.applyToArrow(arrow);
            this.field_70170_p.func_72838_d((Entity)arrow);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
    }
}

