/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs.block;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import toast.utilityMobs.block.EntityBlockGolem;

public abstract class EntityContainerGolem
extends EntityBlockGolem
implements IInventory {
    private ItemStack[] contents = new ItemStack[36];

    public EntityContainerGolem(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(31, (Object)0);
    }

    public void incNumUsingPlayers() {
        this.field_70180_af.func_75692_b(31, (Object)((byte)(this.field_70180_af.func_75683_a(31) + 1)));
    }

    public void decNumUsingPlayers() {
        this.field_70180_af.func_75692_b(31, (Object)((byte)(this.field_70180_af.func_75683_a(31) - 1)));
    }

    public boolean isOpen() {
        return this.field_70180_af.func_75683_a(31) > 0;
    }

    @Override
    public void setClosed() {
        this.field_70180_af.func_75692_b(31, (Object)0);
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.contents[slot] != null) {
            if (this.contents[slot].field_77994_a <= amount) {
                ItemStack itemStack = this.contents[slot];
                this.contents[slot] = null;
                return itemStack;
            }
            ItemStack itemStack = this.contents[slot].func_77979_a(amount);
            if (this.contents[slot].field_77994_a == 0) {
                this.contents[slot] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.contents[slot] != null) {
            ItemStack itemStack = this.contents[slot];
            this.contents[slot] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.contents[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_94056_bM() ? this.func_94057_bL() : "Chest Golem";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canInteract(player);
    }

    public void func_70295_k_() {
        this.incNumUsingPlayers();
    }

    public void func_70305_f() {
        this.decNumUsingPlayers();
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return true;
    }

    public void func_70296_d() {
    }

    @Override
    protected void dropFewItems(boolean recentlyHit, int looting, float dropChance) {
        super.dropFewItems(recentlyHit, looting, dropChance);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.contents[i] == null) continue;
            ItemStack split = this.contents[i].func_77946_l();
            while (this.contents[i].field_77994_a > 0) {
                int splitSize = this.field_70146_Z.nextInt(21) + 10;
                if (splitSize > this.contents[i].field_77994_a) {
                    splitSize = this.contents[i].field_77994_a;
                }
                this.contents[i].field_77994_a -= splitSize;
                split.field_77994_a = splitSize;
                this.func_70099_a(split, 0.0f);
            }
            this.contents[i] = null;
        }
    }

    @Override
    public boolean openGUI(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            player.func_71007_a((IInventory)this);
        }
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.contents.length; ++slot) {
            if (this.contents[slot] == null) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)slot);
            this.contents[slot].func_77955_b(slotTag);
            tagList.func_74742_a((NBTBase)slotTag);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", (int)tag.func_74732_a());
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound slotTag = tagList.func_150305_b(i);
            int slot = slotTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.contents.length) continue;
            this.contents[slot] = ItemStack.func_77949_a((NBTTagCompound)slotTag);
        }
    }

    public void takeContentsFromNBT(NBTTagCompound tag) {
        NBTTagList tagList = tag.func_150295_c("Items", (int)tag.func_74732_a());
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound slotTag = tagList.func_150305_b(i);
            int slot = slotTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.contents.length) continue;
            this.contents[slot] = ItemStack.func_77949_a((NBTTagCompound)slotTag);
        }
        tag.func_74782_a("Items", (NBTBase)new NBTTagList());
        if (tag.func_74764_b("CustomName")) {
            this.func_94058_c(tag.func_74779_i("CustomName"));
        }
        tag.func_82580_o("CustomName");
    }
}

