/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum EnumUpgrade {
    DEFAULT("default", null),
    MULTISHOT("multishot", null),
    KILLER("killer", Items.field_151045_i),
    FIRE("fire", Items.field_151042_j),
    FEATHER("feather", Items.field_151008_G),
    SLOW("slow", Items.field_151123_aH),
    EGG("egg", Items.field_151110_aK),
    SIGHT("sight", Items.field_151079_bi),
    EXPLOSIVE("explosive", Items.field_151016_H),
    POISON("poison", Items.field_151070_bp),
    FIRE_EXPLOSIVE("fire_explosive", Items.field_151059_bz);

    public final String upgradeName;
    public final Item upgradeItem;

    public static EnumUpgrade getUpgrade(EnumUpgrade[] upgrades, ItemStack upgradeStack) {
        if (upgradeStack != null) {
            Item upgradeItem = upgradeStack.func_77973_b();
            for (EnumUpgrade upgrade : upgrades) {
                if (upgrade.upgradeItem != upgradeItem) continue;
                return upgrade;
            }
        }
        return DEFAULT;
    }

    public static EnumUpgrade getUpgrade(ItemStack upgradeStack) {
        return EnumUpgrade.getUpgrade(EnumUpgrade.values(), upgradeStack);
    }

    private EnumUpgrade(String id, Item upgrade) {
        this.upgradeName = id;
        this.upgradeItem = upgrade;
    }

    public void applyToArrow(EntityArrow arrow) {
        switch (this) {
            case EXPLOSIVE: {
                arrow.func_70239_b(arrow.func_70242_d() - 1.0);
                break;
            }
            case FIRE: {
                arrow.func_70239_b(arrow.func_70242_d() - 1.0);
                arrow.func_70015_d(100);
                break;
            }
            case FIRE_EXPLOSIVE: {
                arrow.func_70239_b(arrow.func_70242_d() - 2.0);
                arrow.func_70015_d(100);
                break;
            }
            case KILLER: {
                arrow.func_70239_b(arrow.func_70242_d() * 1.5 + 1.0);
                break;
            }
        }
        if (arrow.func_70242_d() <= 0.0) {
            arrow.func_70239_b(Double.MIN_VALUE);
        }
        this.applyTo((Entity)arrow);
    }

    public void applyTo(Entity entity) {
        entity.getEntityData().func_74757_a("UM|" + this.upgradeName, true);
    }

    public boolean isApplied(Entity entity) {
        return entity.getEntityData().func_74767_n("UM|" + this.upgradeName);
    }
}

