/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import toast.utilityMobs.golem.EntityUtilityGolem;

public class EntityGolemFishHook
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private boolean inGround = false;
    public int shake = 0;
    public EntityUtilityGolem angler = null;
    private int ticksInGround = 0;
    private int ticksInAir = 0;

    public EntityGolemFishHook(World world) {
        super(world);
    }

    public EntityGolemFishHook(World world, EntityUtilityGolem golem, Entity target) {
        super(world);
        this.angler = golem;
        this.func_70012_b(golem.field_70165_t, golem.field_70163_u + 1.62 - (double)golem.field_70129_M, golem.field_70161_v, golem.field_70177_z, golem.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = (target.field_70165_t - golem.field_70165_t) * 0.7;
        this.field_70181_x = (target.field_70163_u + (double)target.func_70047_e() - 0.7 - this.field_70163_u) * 0.7;
        this.field_70179_y = (target.field_70161_v - golem.field_70161_v) * 0.7;
        double vH = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        if (vH >= 1.0E-7) {
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            this.field_70125_A = (float)(-Math.atan2(this.field_70181_x, vH) * 180.0 / Math.PI);
            double dX = this.field_70159_w / vH;
            double dZ = this.field_70179_y / vH;
            this.func_70012_b(golem.field_70165_t + dX, this.field_70163_u, golem.field_70161_v + dZ, this.field_70177_z, this.field_70125_A);
            this.field_70129_M = 0.0f;
            this.calculateVelocity(this.field_70159_w, this.field_70181_x + vH * 0.2, this.field_70179_y, 1.0f, 14 - (this.field_70170_p.field_73013_u.func_151525_a() << 2));
        }
    }

    protected void func_70088_a() {
        this.func_70105_a(0.25f, 0.25f);
    }

    public boolean func_70112_a(double d) {
        double d1 = this.field_70121_D.func_72320_b() * 256.0;
        return d < d1 * d1;
    }

    public void calculateVelocity(double vX, double vY, double vZ, float v, float variance) {
        float vi = MathHelper.func_76133_a((double)(vX * vX + vY * vY + vZ * vZ));
        vX /= (double)vi;
        vY /= (double)vi;
        vZ /= (double)vi;
        vX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        vY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        vZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)variance;
        this.field_70159_w = vX *= (double)v;
        this.field_70181_x = vY *= (double)v;
        this.field_70179_y = vZ *= (double)v;
        float vH = MathHelper.func_76133_a((double)(vX * vX + vZ * vZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vX, vZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vY, vH) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void func_70016_h(double vX, double vY, double vZ) {
        this.field_70159_w = vX;
        this.field_70181_x = vY;
        this.field_70179_y = vZ;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float vH = MathHelper.func_76133_a((double)(vX * vX + vZ * vZ));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vX, vZ) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vY, vH) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.angler == null || this.angler.field_70128_L || this.func_70068_e((Entity)this.angler) > 1024.0) {
            this.func_70106_y();
        }
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.inGround) {
            Block inBlock = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
            if (inBlock == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3 posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 motionVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition object = this.field_70170_p.func_72933_a(posVec, motionVec);
        posVec = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        motionVec = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (object != null) {
            motionVec = Vec3.func_72443_a((double)object.field_72307_f.field_72450_a, (double)object.field_72307_f.field_72448_b, (double)object.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity entityHit = null;
            List entitiesInPath = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < entitiesInPath.size(); ++i) {
                double d1;
                AxisAlignedBB aabb;
                MovingObjectPosition object1;
                Entity entityInPath = (Entity)entitiesInPath.get(i);
                if (!entityInPath.func_70067_L() || entityInPath.func_70028_i((Entity)this.angler) || (object1 = (aabb = entityInPath.field_70121_D.func_72314_b(0.3, 0.3, 0.3)).func_72327_a(posVec, motionVec)) == null || !((d1 = posVec.func_72438_d(object1.field_72307_f)) < d)) continue;
                entityHit = entityInPath;
                d = d1;
            }
            if (entityHit != null) {
                object = new MovingObjectPosition(entityHit);
            }
        }
        if (object != null) {
            this.onImpact(object);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float var16 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var16) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.99;
        this.field_70179_y *= 0.99;
        this.field_70181_x -= (double)this.getGravityVelocity();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void onImpact(MovingObjectPosition object) {
        if (object.field_72308_g != null) {
            double vX = this.angler.field_70165_t - this.field_70165_t;
            double vY = this.angler.field_70163_u - this.field_70163_u;
            double vZ = this.angler.field_70161_v - this.field_70161_v;
            double v = Math.sqrt(vX * vX + vY * vY + vZ * vZ);
            double mult = 0.31;
            object.field_72308_g.field_70159_w = vX * mult;
            object.field_72308_g.field_70181_x = vY * mult + Math.sqrt(v) * 0.1;
            object.field_72308_g.field_70179_y = vZ * mult;
            object.field_72308_g.field_70122_E = false;
            if (object.field_72308_g instanceof EntityPlayerMP) {
                try {
                    ((EntityPlayerMP)object.field_72308_g).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(object.field_72308_g));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.func_70106_y();
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public void func_70106_y() {
        if (this.angler != null) {
            this.angler.setFishingRod(true);
        }
        super.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74777_a("xTile", (short)this.xTile);
        tag.func_74777_a("yTile", (short)this.yTile);
        tag.func_74777_a("zTile", (short)this.zTile);
        tag.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        tag.func_74774_a("shake", (byte)this.shake);
        tag.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.xTile = tag.func_74765_d("xTile");
        this.yTile = tag.func_74765_d("yTile");
        this.zTile = tag.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(tag.func_74771_c("inTile") & 0xFF));
        this.shake = tag.func_74771_c("shake") & 0xFF;
        this.inGround = tag.func_74771_c("inGround") == 1;
    }
}

