/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.utils;

import minetweaker.IUndoableAction;
import modtweaker2.helpers.ReflectionHelper;

public abstract class BaseSetVar
implements IUndoableAction {
    protected final String description;
    protected final Class clazz;
    protected final String field;
    protected final int original;
    protected final int newValue;
    protected Object object;

    public BaseSetVar(String description, Class clazz, Object object, String field, int original, int newValue) {
        this(description, clazz, field, original, newValue);
        this.object = object;
    }

    public BaseSetVar(String description, Class clazz, String field, int original, int newValue) {
        this.description = description;
        this.clazz = clazz;
        this.field = field;
        this.original = original;
        this.newValue = newValue;
    }

    public void apply() {
        ReflectionHelper.setPrivateValue(this.clazz, this.object, this.field, this.newValue);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        ReflectionHelper.setPrivateValue(this.clazz, this.object, this.field, this.original);
    }

    public String describe() {
        return "Setting " + this.description + " to " + this.newValue;
    }

    public String describeUndo() {
        return "Setting " + this.description + " to the default value of " + this.original;
    }

    public Object getOverrideKey() {
        return null;
    }
}

