/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.utils;

import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;

public abstract class BaseMultipleListRemoval
implements IUndoableAction {
    protected final Position pos;
    protected final String description;
    protected final List list;
    protected final Object search;
    protected ArrayList<Object> recipes;

    public BaseMultipleListRemoval(String description, List list, Object search, Position pos) {
        this.pos = pos;
        this.description = description;
        this.list = list;
        this.search = search;
    }

    protected abstract boolean isEqual(Object var1, Object var2);

    public void apply() {
        this.recipes = new ArrayList();
        for (Object e : this.list) {
            if (!this.isEqual(e, this.search)) continue;
            if (this.pos == Position.LAST) {
                this.recipes = new ArrayList();
            }
            this.recipes.add(e);
            if (this.pos != Position.FIRST) continue;
            break;
        }
        for (Object object : this.recipes) {
            this.list.remove(object);
        }
    }

    public boolean canUndo() {
        return this.recipes != null;
    }

    public void undo() {
        for (Object o : this.recipes) {
            this.list.add(o);
        }
    }

    public abstract String getRecipeInfo();

    public String describe() {
        return "Removing " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public String describeUndo() {
        return "Restoring " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public Object getOverrideKey() {
        return null;
    }

    public static enum Position {
        ALL,
        FIRST,
        LAST;

    }
}

