/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.utils;

import java.util.Map;
import minetweaker.IUndoableAction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseMapRemoval
implements IUndoableAction {
    protected final Map map;
    protected Object stack;
    protected String description;
    protected Object key;
    protected Object recipe;

    public BaseMapRemoval(Object stack, Map map, Object key) {
        this(null, map, key, stack);
    }

    public BaseMapRemoval(String description, Map map, Object stack) {
        this(description, map, null, stack);
    }

    public BaseMapRemoval(String description, Map map, Object key, Object stack) {
        this.stack = stack;
        this.map = map;
        this.key = key;
        this.description = description;
    }

    public void apply() {
        this.recipe = this.map.get(this.key);
        this.map.remove(this.key);
    }

    public boolean canUndo() {
        return this.map != null;
    }

    public void undo() {
        this.map.put(this.key, this.recipe);
    }

    public String getRecipeInfo() {
        return "Unknown Item";
    }

    public String describe() {
        if (this.recipe instanceof ItemStack) {
            return "Removing " + this.description + " Recipe for : " + ((ItemStack)this.recipe).func_82833_r();
        }
        if (this.recipe instanceof FluidStack) {
            return "Removing " + this.description + " Recipe for : " + ((FluidStack)this.recipe).getFluid().getLocalizedName();
        }
        return "Removing " + this.description + " Recipe for :" + this.getRecipeInfo();
    }

    public String describeUndo() {
        if (this.recipe instanceof ItemStack) {
            return "Restoring " + this.description + " Recipe for : " + ((ItemStack)this.recipe).func_82833_r();
        }
        if (this.recipe instanceof FluidStack) {
            return "Restoring " + this.description + " Recipe for : " + ((FluidStack)this.recipe).getFluid().getLocalizedName();
        }
        return "Restoring " + this.description + " Recipe for : " + this.getRecipeInfo();
    }

    public Object getOverrideKey() {
        return null;
    }
}

