/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thermalexpansion.handlers;

import cofh.thermalexpansion.util.crafting.SawmillManager;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Sawmill")
public class Sawmill {
    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add(energy, InputHelper.toStack(input), InputHelper.toStack(output), null, 0));
    }

    @ZenMethod
    public static void addRecipe(int energy, IItemStack input, IItemStack output, IItemStack secondary, int secondaryChance) {
        MineTweakerAPI.apply((IUndoableAction)new Add(energy, InputHelper.toStack(input), InputHelper.toStack(output), InputHelper.toStack(secondary), secondaryChance));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input)));
    }

    private static class Remove
    implements IUndoableAction {
        ItemStack input;
        SawmillManager.RecipeSawmill removed;

        public Remove(ItemStack inp) {
            this.input = inp;
        }

        public void apply() {
            this.removed = SawmillManager.getRecipe((ItemStack)this.input);
            SawmillManager.removeRecipe((ItemStack)this.input);
        }

        public boolean canUndo() {
            return this.removed != null;
        }

        public String describe() {
            return "Removing Sawmill Recipe using " + this.input.func_82833_r();
        }

        public void undo() {
            SawmillManager.addRecipe((int)this.removed.getEnergy(), (ItemStack)this.removed.getInput(), (ItemStack)this.removed.getPrimaryOutput(), (ItemStack)this.removed.getSecondaryOutput(), (int)this.removed.getSecondaryOutputChance());
        }

        public String describeUndo() {
            return "Restoring Sawmill Recipe using " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        ItemStack input;
        ItemStack output;
        ItemStack secondary;
        int secondaryChance;
        int energy;
        boolean applied = false;

        public Add(int rf, ItemStack inp, ItemStack out, ItemStack sec, int chance) {
            this.energy = rf;
            this.input = inp;
            this.output = out;
            this.secondary = sec;
            this.secondaryChance = chance;
        }

        public void apply() {
            this.applied = SawmillManager.addRecipe((int)this.energy, (ItemStack)this.input, (ItemStack)this.output, (ItemStack)this.secondary, (int)this.secondaryChance);
        }

        public boolean canUndo() {
            return this.input != null && this.applied;
        }

        public String describe() {
            return "Adding Sawmill Recipe using " + this.input.func_82833_r();
        }

        public void undo() {
            SawmillManager.removeRecipe((ItemStack)this.input);
        }

        public String describeUndo() {
            return "Removing Sawmill Recipe using " + this.input.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

