/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import java.util.Arrays;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.utils.BaseDescriptionAddition;
import modtweaker2.utils.BaseDescriptionRemoval;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;

@ZenClass(value="mods.thaumcraft.Aspects")
public class Aspects {
    @ZenMethod
    public static void add(IItemStack stack, String aspects) {
        MineTweakerAPI.apply((IUndoableAction)new Add(InputHelper.toStack(stack), aspects, false));
    }

    @ZenMethod
    public static void set(IItemStack stack, String aspects) {
        MineTweakerAPI.apply((IUndoableAction)new Add(InputHelper.toStack(stack), aspects, true));
    }

    @ZenMethod
    public static void remove(IItemStack stack, String aspects) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(stack), aspects));
    }

    @ZenMethod
    public static void addEntity(String entityName, String aspects) {
        if (!EntityList.field_75625_b.containsKey(entityName)) {
            MineTweakerAPI.getLogger().logError("No such entity " + entityName);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddEntity(entityName, aspects, false));
    }

    @ZenMethod
    public static void setEntity(String entityName, String aspects) {
        if (!EntityList.field_75625_b.containsKey(entityName)) {
            MineTweakerAPI.getLogger().logError("No such entity " + entityName);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddEntity(entityName, aspects, true));
    }

    @ZenMethod
    public static void removeEntity(String entityName, String aspects) {
        if (!EntityList.field_75625_b.containsKey(entityName)) {
            MineTweakerAPI.getLogger().logError("No such entity " + entityName);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveEntity(entityName, aspects));
    }

    private static class RemoveEntity
    extends BaseDescriptionRemoval {
        private final String entityName;
        private final String aspects;
        private AspectList oldList;
        private AspectList newList;

        public RemoveEntity(String entityName, String aspects) {
            super("Aspects");
            this.entityName = entityName;
            this.aspects = aspects;
        }

        public void apply() {
            this.oldList = ThaumcraftHelper.getEntityAspects(this.entityName);
            if (this.oldList != null) {
                this.newList = ThaumcraftHelper.removeAspects(this.oldList, this.aspects);
                ThaumcraftHelper.removeEntityAspects(this.entityName);
                ThaumcraftApi.registerEntityTag((String)this.entityName, (AspectList)this.newList, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
            }
        }

        @Override
        public boolean canUndo() {
            return this.oldList != null;
        }

        public void undo() {
            ThaumcraftHelper.removeEntityAspects(this.entityName);
            ThaumcraftApi.registerEntityTag((String)this.entityName, (AspectList)this.oldList, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        }

        @Override
        public String getRecipeInfo() {
            return this.entityName;
        }
    }

    private static class AddEntity
    extends BaseDescriptionAddition {
        private final String entityName;
        private final String aspects;
        private final boolean replace;
        private AspectList oldList;
        private AspectList newList;

        public AddEntity(String entityName, String aspects, boolean replace) {
            super("Aspects");
            this.entityName = entityName;
            this.aspects = aspects;
            this.replace = replace;
        }

        public void apply() {
            this.oldList = ThaumcraftHelper.getEntityAspects(this.entityName);
            this.newList = !this.replace ? ThaumcraftHelper.parseAspects(this.oldList, this.aspects) : ThaumcraftHelper.parseAspects(this.aspects);
            ThaumcraftHelper.removeEntityAspects(this.entityName);
            ThaumcraftApi.registerEntityTag((String)this.entityName, (AspectList)this.newList, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        }

        public void undo() {
            ThaumcraftHelper.removeEntityAspects(this.entityName);
            if (this.oldList != null) {
                ThaumcraftApi.registerEntityTag((String)this.entityName, (AspectList)this.oldList, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
            }
        }

        @Override
        public String getRecipeInfo() {
            return this.entityName;
        }
    }

    private static class Remove
    extends BaseDescriptionRemoval {
        private final ItemStack stack;
        private final String aspects;
        private AspectList oldList;
        private AspectList newList;

        public Remove(ItemStack stack, String aspects) {
            super("Aspects");
            this.stack = stack;
            this.aspects = aspects;
        }

        public void apply() {
            this.oldList = ThaumcraftApiHelper.getObjectAspects((ItemStack)this.stack);
            if (this.oldList != null) {
                this.newList = ThaumcraftHelper.removeAspects(this.oldList, this.aspects);
                ThaumcraftApi.objectTags.put(Arrays.asList(this.stack.func_77973_b(), this.stack.func_77960_j()), this.newList);
            }
        }

        @Override
        public boolean canUndo() {
            return this.oldList != null;
        }

        public void undo() {
            ThaumcraftApi.objectTags.put(Arrays.asList(this.stack.func_77973_b(), this.stack.func_77960_j()), this.oldList);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseDescriptionAddition {
        private final ItemStack stack;
        private final String aspects;
        private final boolean replace;
        private AspectList oldList;
        private AspectList newList;

        public Add(ItemStack stack, String aspects, boolean replace) {
            super("Aspects");
            this.stack = stack;
            this.aspects = aspects;
            this.replace = replace;
        }

        public void apply() {
            this.oldList = ThaumcraftApiHelper.getObjectAspects((ItemStack)this.stack);
            this.newList = !this.replace ? ThaumcraftHelper.parseAspects(this.oldList, this.aspects) : ThaumcraftHelper.parseAspects(this.aspects);
            ThaumcraftApi.objectTags.put(Arrays.asList(this.stack.func_77973_b(), this.stack.func_77960_j()), this.newList);
        }

        public void undo() {
            if (this.oldList == null) {
                ThaumcraftApi.objectTags.remove(Arrays.asList(this.stack.func_77973_b(), this.stack.func_77960_j()));
            } else {
                ThaumcraftApi.objectTags.put(Arrays.asList(this.stack.func_77973_b(), this.stack.func_77960_j()), this.oldList);
            }
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }
}

