/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft;

import java.util.ArrayList;
import java.util.HashMap;
import modtweaker2.helpers.ReflectionHelper;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;

public class ThaumcraftHelper {
    public static ArrayList recipes = null;
    public static HashMap<Object, Integer> warpList;

    private ThaumcraftHelper() {
    }

    public static AspectList parseAspects(String aspects) {
        return ThaumcraftHelper.parseAspects(new AspectList(), aspects);
    }

    public static AspectList parseAspects(AspectList list, String str) {
        String[] aspects;
        AspectList output = new AspectList();
        if (list != null) {
            for (Aspect aspect : list.getAspectsSortedAmount()) {
                if (aspect == null) continue;
                output.add(aspect, list.getAmount(aspect));
            }
        }
        if (str == null || str.equals("")) {
            return list;
        }
        for (String aspect : aspects = str.split(",")) {
            String[] aspct;
            if (aspect.startsWith(" ")) {
                aspect = aspect.replaceFirst(" ", "");
            }
            if ((aspct = aspect.split("\\s+")).length != 2) continue;
            output.add((Aspect)Aspect.aspects.get(aspct[0]), Integer.parseInt(aspct[1]));
        }
        return output;
    }

    public static AspectList removeAspects(AspectList list, String str) {
        String[] aspects;
        AspectList output = new AspectList();
        if (list != null) {
            for (Aspect aspect : list.getAspectsSortedAmount()) {
                if (aspect == null) continue;
                output.add(aspect, list.getAmount(aspect));
            }
        }
        for (String aspect : aspects = str.split(",")) {
            String[] aspct;
            if (aspect.startsWith(" ")) {
                aspect = aspect.replaceFirst(" ", "");
            }
            if ((aspct = aspect.split("\\s+")).length != 2) continue;
            output.remove((Aspect)Aspect.aspects.get(aspct[0]), Integer.parseInt(aspct[1]));
        }
        return output;
    }

    public static String getResearchTab(String key) {
        for (String tab : ResearchCategories.researchCategories.keySet()) {
            for (String research : ((ResearchCategoryList)ResearchCategories.researchCategories.get((Object)tab)).research.keySet()) {
                if (!research.equals(key)) continue;
                return tab;
            }
        }
        return null;
    }

    public static AspectList getEntityAspects(String name) {
        for (ThaumcraftApi.EntityTags tag : ThaumcraftApi.scanEntities) {
            if (tag.entityName != name || tag.nbts.length != 0) continue;
            return tag.aspects;
        }
        return null;
    }

    public static void removeEntityAspects(String name) {
        ArrayList tags = new ArrayList(ThaumcraftApi.scanEntities);
        for (ThaumcraftApi.EntityTags tag : tags) {
            if (tag.entityName != name || tag.nbts.length != 0) continue;
            ThaumcraftApi.scanEntities.remove(tag);
        }
    }

    public static String aspectsToString(AspectList aspects) {
        System.out.println(aspects);
        String output = "";
        for (Aspect aspect : aspects.getAspectsSortedAmount()) {
            if (aspect == null) continue;
            output = output + aspect.getName() + " " + aspects.getAmount(aspect) + ",";
        }
        return output;
    }

    static {
        try {
            recipes = (ArrayList)ReflectionHelper.getStaticObject(ThaumcraftApi.class, "recipes");
            warpList = (HashMap)ReflectionHelper.getStaticObject(ThaumcraftApi.class, "warpMap");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

