/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import modtweaker2.utils.BaseCraftingAddition;
import modtweaker2.utils.BaseCraftingRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.railcraft.Rolling")
public class RollingMachine {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(false, InputHelper.toStack(output), InputHelper.toShapedObjects(ingredients)));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(true, InputHelper.toStack(output), InputHelper.toObjects(ingredients)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output)));
    }

    private static class Remove
    extends BaseCraftingRemoval {
        public Remove(ItemStack stack) {
            super("Rolling Machine", RailcraftHelper.rolling, stack);
        }
    }

    private static class Add
    extends BaseCraftingAddition {
        public Add(boolean shapeless, ItemStack output, Object ... recipe) {
            super("Rolling Machine", shapeless, RailcraftHelper.rolling, output, recipe);
        }

        @Override
        public void applyShaped() {
            RailcraftCraftingManager.rollingMachine.addRecipe(this.output, this.recipe);
        }

        @Override
        public void applyShapeless() {
            RailcraftCraftingManager.rollingMachine.addShapelessRecipe(this.output, this.recipe);
        }
    }
}

