/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import mods.railcraft.api.crafting.ICokeOvenRecipe;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.railcraft.CokeOven")
public class CokeOven {
    @ZenMethod
    public static void addRecipe(IItemStack input, boolean matchDamage, boolean matchNBT, IItemStack output, ILiquidStack fluidOutput, int cookTime) {
        MineTweakerAPI.apply((IUndoableAction)new Add(RailcraftHelper.getCokeOvenRecipe(InputHelper.toStack(input), matchDamage, matchNBT, InputHelper.toStack(output), InputHelper.toFluid(fluidOutput), cookTime)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(output)));
    }

    private static class Remove
    extends BaseListRemoval {
        public Remove(ItemStack stack) {
            super("Coke Oven", RailcraftHelper.oven, stack);
        }

        public void apply() {
            for (ICokeOvenRecipe iCokeOvenRecipe : RailcraftHelper.oven) {
                if (iCokeOvenRecipe.getOutput() == null || !StackHelper.areEqual(iCokeOvenRecipe.getOutput(), this.stack)) continue;
                this.recipe = iCokeOvenRecipe;
                break;
            }
            RailcraftHelper.oven.remove(this.recipe);
        }

        @Override
        public String getRecipeInfo() {
            return this.stack.func_82833_r();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(ICokeOvenRecipe recipe) {
            super("Coke Oven", RailcraftHelper.oven, recipe);
        }

        @Override
        public String getRecipeInfo() {
            return ((ICokeOvenRecipe)this.recipe).getOutput().func_82833_r();
        }
    }
}

