/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.metallurgy.handlers;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.metallurgy.MetallurgyHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.metallurgy.Crusher")
public class Crusher {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add(InputHelper.toStack(input), InputHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(input)));
    }

    private static void addToInput(ItemStack input, ItemStack output) {
        ItemStack[] inputList = MetallurgyHelper.crusherInputList.get(output.func_77977_a());
        if (inputList == null) {
            inputList = new ItemStack[]{input};
        } else {
            ItemStack[] newList = new ItemStack[inputList.length + 1];
            for (int i = 0; i < inputList.length; ++i) {
                newList[i] = inputList[i];
            }
            newList[inputList.length] = input;
            inputList = newList;
        }
        MetallurgyHelper.crusherInputList.put(output.func_77977_a(), inputList);
    }

    private static void removeFromInput(ItemStack input, ItemStack output) {
        boolean switched = false;
        ItemStack[] inputList = MetallurgyHelper.crusherInputList.get(output.func_77977_a());
        ItemStack[] newList = new ItemStack[inputList.length - 1];
        if (newList.length >= 1) {
            for (int i = 0; i < newList.length; ++i) {
                if (switched || StackHelper.areEqual(inputList[i], input)) {
                    switched = true;
                    newList[i] = inputList[i + 1];
                    continue;
                }
                newList[i] = inputList[i];
            }
        } else {
            newList = null;
        }
        if ((inputList = newList) == null || inputList.length <= 0) {
            MetallurgyHelper.crusherInputList.remove(output.func_77977_a());
        } else {
            MetallurgyHelper.crusherInputList.put(output.func_77977_a(), inputList);
        }
    }

    private static class Remove
    extends BaseMapRemoval {
        public Remove(ItemStack stack) {
            super("Metallurgy Crusher", MetallurgyHelper.crusherMetaList, MetallurgyHelper.getCrusherKey(stack), stack);
        }

        @Override
        public String getRecipeInfo() {
            return ((ItemStack)this.stack).func_82833_r();
        }

        @Override
        public void apply() {
            super.apply();
            Crusher.removeFromInput((ItemStack)this.stack, (ItemStack)this.recipe);
        }

        @Override
        public void undo() {
            super.undo();
            Crusher.addToInput((ItemStack)this.stack, (ItemStack)this.recipe);
        }
    }

    private static class Add
    extends BaseMapAddition {
        private final ItemStack stack;

        public Add(ItemStack input, ItemStack output) {
            super("Metallurgy Crusher", MetallurgyHelper.crusherMetaList, MetallurgyHelper.getCrusherKey(input), output);
            this.stack = input;
        }

        @Override
        public void apply() {
            super.apply();
            Crusher.addToInput(this.stack, (ItemStack)this.recipe);
        }

        @Override
        public void undo() {
            super.undo();
            Crusher.removeFromInput(this.stack, (ItemStack)this.recipe);
        }
    }
}

