/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mariculture.handlers;

import java.util.List;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeVat;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mariculture.Vat")
public class Vat {
    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, ILiquidStack outputFluid, int time) {
        Vat.addRecipe(fluid1, fluid2, null, outputFluid, null, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, fluid2, null, null, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, ILiquidStack outputFluid, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, fluid2, null, outputFluid, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, IItemStack input, ILiquidStack outputFluid, int time) {
        Vat.addRecipe(fluid1, null, input, outputFluid, null, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, IItemStack input, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, null, input, null, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, IItemStack input, ILiquidStack outputFluid, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, null, input, outputFluid, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, IItemStack input, ILiquidStack outputFluid, int time) {
        Vat.addRecipe(fluid1, fluid2, input, outputFluid, null, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, IItemStack input, IItemStack outputItem, int time) {
        Vat.addRecipe(fluid1, fluid2, input, null, outputItem, time);
    }

    @ZenMethod
    public static void addRecipe(ILiquidStack fluid1, ILiquidStack fluid2, IItemStack input, ILiquidStack outputFluid, IItemStack outputItem, int time) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeVat((Object)InputHelper.toStack(input), InputHelper.toFluid(fluid1), InputHelper.toFluid(fluid2), InputHelper.toFluid(outputFluid), InputHelper.toStack(outputItem), time)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack outputItem) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(outputItem), null));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack outputFluid) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(null, InputHelper.toFluid(outputFluid)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack outputItem, ILiquidStack outputFluid) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack(outputItem), InputHelper.toFluid(outputFluid)));
    }

    private static class Remove
    extends BaseListRemoval {
        private FluidStack fluid = null;

        public Remove(ItemStack stack, FluidStack fluid) {
            super("Mariculture Vat", (List)MaricultureHandlers.vat.getRecipes(), stack);
            if (fluid != null) {
                this.fluid = fluid;
            }
        }

        public void apply() {
            for (RecipeVat r : MaricultureHandlers.vat.getRecipes()) {
                if (r != null && r.outputItem != null && this.stack != null && StackHelper.areEqual(r.outputItem, this.stack) && (r.outputFluid == null || this.fluid != null && r.outputFluid.isFluidStackIdentical(this.fluid))) {
                    this.recipe = r;
                    break;
                }
                if (r.outputFluid == null || this.fluid == null || !r.outputFluid.isFluidStackIdentical(this.fluid)) continue;
                this.recipe = r;
                break;
            }
            if (this.recipe != null) {
                MaricultureHandlers.vat.getRecipes().remove(this.recipe);
            }
        }

        @Override
        public String getRecipeInfo() {
            return this.stack != null ? this.stack.func_82833_r() : this.fluid.getFluid().getLocalizedName();
        }
    }

    private static class Add
    extends BaseListAddition {
        public Add(RecipeVat recipe) {
            super("Mariculture Vat", MaricultureHandlers.vat.getRecipes(), recipe);
        }

        @Override
        public String getRecipeInfo() {
            if (((RecipeVat)this.recipe).outputItem != null) {
                return ((RecipeVat)this.recipe).outputItem.func_82833_r();
            }
            return ((RecipeVat)this.recipe).outputFluid.getFluid().getLocalizedName();
        }
    }
}

