/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common.network;

import com.google.gson.JsonSyntaxException;
import com.mojang.util.UUIDTypeAdapter;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import kihira.tails.common.PartsData;
import kihira.tails.common.Tails;

public class PlayerDataMessage
implements IMessage {
    private UUID uuid;
    private PartsData partsData;
    private boolean shouldRemove;

    public PlayerDataMessage() {
    }

    public PlayerDataMessage(UUID uuid, PartsData partsData, boolean shouldRemove) {
        this.uuid = uuid;
        this.partsData = partsData;
        this.shouldRemove = shouldRemove;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = UUIDTypeAdapter.fromString((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        String tailInfoJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            this.partsData = (PartsData)Tails.gson.fromJson(tailInfoJson, PartsData.class);
        }
        catch (JsonSyntaxException e) {
            Tails.logger.warn((Object)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)UUIDTypeAdapter.fromUUID((UUID)this.uuid));
        String tailInfoJson = Tails.gson.toJson((Object)this.partsData);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tailInfoJson);
    }

    public static class Handler
    implements IMessageHandler<PlayerDataMessage, IMessage> {
        public IMessage onMessage(PlayerDataMessage message, MessageContext ctx) {
            if (message.partsData != null) {
                if (message.shouldRemove) {
                    Tails.proxy.removePartsData(message.uuid);
                } else {
                    Tails.proxy.addPartsData(message.uuid, message.partsData);
                    if (ctx.side.isServer()) {
                        Tails.networkWrapper.sendToAll((IMessage)new PlayerDataMessage(message.uuid, message.partsData, false));
                    }
                }
            }
            return null;
        }
    }
}

