/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common;

import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import java.util.Arrays;
import kihira.tails.common.PartInfo;

public class PartsData {
    @Expose
    private final PartInfo[] partInfos = new PartInfo[PartType.values().length];

    public void setPartInfo(PartType partType, PartInfo partInfo) {
        this.partInfos[partType.ordinal()] = partInfo;
    }

    public PartInfo getPartInfo(PartType partType) {
        return this.partInfos[partType.ordinal()];
    }

    public boolean hasPartInfo(PartType partType) {
        PartInfo partInfo = this.partInfos[partType.ordinal()];
        return partInfo != null && partInfo.hasPart;
    }

    public void clearTextures() {
        for (PartInfo partInfo : this.partInfos) {
            if (partInfo == null) continue;
            partInfo.setTexture(null);
        }
    }

    public PartsData deepCopy() {
        Gson gson = new Gson();
        return (PartsData)gson.fromJson(gson.toJson((Object)this), PartsData.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartsData partsData = (PartsData)o;
        return Arrays.equals(this.partInfos, partsData.partInfos);
    }

    public int hashCode() {
        return this.partInfos != null ? Arrays.hashCode(this.partInfos) : 0;
    }

    public static enum PartType {
        TAIL,
        EARS,
        WINGS;

    }
}

