/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility;

import exnihilo.ExNihilo;
import exnihilo.blocks.BlockBarrel;
import exnihilo.blocks.BlockCrucible;
import exnihilo.blocks.BlockLeavesInfested;
import exnihilo.blocks.BlockSieve;
import exnihilo.blocks.tileentities.TileEntityBarrel;
import exnihilo.blocks.tileentities.TileEntityCrucible;
import exnihilo.blocks.tileentities.TileEntityLeavesInfested;
import exnihilo.blocks.tileentities.TileEntitySieve;
import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Waila
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack stack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock() instanceof BlockBarrel) {
            TileEntityBarrel teBarrel = (TileEntityBarrel)accessor.getTileEntity();
            currentTip.add(this.getBarrelDisplay(teBarrel.getMode(), teBarrel));
        } else if (accessor.getBlock() instanceof BlockLeavesInfested) {
            TileEntityLeavesInfested teLeaves = (TileEntityLeavesInfested)accessor.getTileEntity();
            currentTip.add(this.getLeavesDisplay(teLeaves));
        } else if (accessor.getBlock() instanceof BlockSieve) {
            TileEntitySieve teSieve = (TileEntitySieve)accessor.getTileEntity();
            currentTip.add(this.getSieveDisplay(teSieve));
        } else if (accessor.getBlock() instanceof BlockCrucible) {
            TileEntityCrucible teCrucible = (TileEntityCrucible)accessor.getTileEntity();
            currentTip.add(this.getCrucibleDisplay(teCrucible));
        }
        return currentTip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currentTip;
    }

    public String getBarrelDisplay(TileEntityBarrel.BarrelMode mode, TileEntityBarrel barrel) {
        DecimalFormat format = new DecimalFormat("##.#");
        switch (mode) {
            case EMPTY: {
                return "Empty";
            }
            case FLUID: {
                if (barrel.isFull()) {
                    return barrel.fluid.getFluid().getName();
                }
                return barrel.fluid.getFluid().getName() + " " + format.format(barrel.getVolume() * 100.0f) + "%";
            }
            case COMPOST: {
                if (barrel.isFull()) {
                    return "Composting: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
                }
                return "Collecting Material: " + format.format(barrel.getVolume() * 100.0f) + "%";
            }
            case DIRT: {
                return "Dirt";
            }
            case CLAY: {
                return "Clay";
            }
            case MILKED: {
                return "Sliming: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
            }
            case SLIME: {
                return "Slime";
            }
            case SPORED: {
                return "Transforming: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
            }
            case ENDER_COOKING: 
            case BLAZE_COOKING: {
                return "Summoning: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
            }
            case ENDER: 
            case BLAZE: {
                return "Incoming!";
            }
            case DARKOAK: {
                return "Dark Oak Sapling";
            }
            case BEETRAP: {
                return "Scented Artifical Hive";
            }
            case COBBLESTONE: {
                return "Cobblestone";
            }
            case ENDSTONE: {
                return "End Stone";
            }
            case NETHERRACK: {
                return "Netherrack";
            }
            case OBSIDIAN: {
                return "Obsidian";
            }
            case SOULSAND: {
                return "Soul Sand";
            }
            case BLOCK: {
                return barrel.block.func_149732_F();
            }
            case RECIPE: {
                return barrel.outputStack.func_82833_r();
            }
            case MOB: {
                return "Summoning: " + Math.round(this.getBarrelTimeRemaining(barrel)) + "%";
            }
        }
        return "";
    }

    public String getLeavesDisplay(TileEntityLeavesInfested leaves) {
        if (leaves.getProgress() >= 1.0f) {
            return "Infested";
        }
        return "Infesting: " + Math.round(this.getLeavesTimeRemaining(leaves)) + "%";
    }

    public String getSieveDisplay(TileEntitySieve sieve) {
        if (sieve.mode == TileEntitySieve.SieveMode.EMPTY) {
            return "Empty";
        }
        return Math.round(this.getSieveClicksRemaining(sieve)) + "% left";
    }

    public String getCrucibleDisplay(TileEntityCrucible crucible) {
        return "Melting Speed: " + crucible.getMeltSpeed() * 10.0f + "x";
    }

    public float getBarrelTimeRemaining(TileEntityBarrel barrel) {
        return (float)barrel.getTimer() / 1000.0f * 100.0f;
    }

    public float getLeavesTimeRemaining(TileEntityLeavesInfested leaves) {
        return leaves.getProgress() / 1.0f * 100.0f;
    }

    public float getSieveClicksRemaining(TileEntitySieve sieve) {
        return sieve.getVolume() / 1.0f * 100.0f;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        Waila instance = new Waila();
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockBarrel.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockLeavesInfested.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockSieve.class);
        registrar.registerBodyProvider((IWailaDataProvider)instance, BlockCrucible.class);
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        ExNihilo.log.info("Waila getNBTData called");
        return tag;
    }
}

