/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelRegister;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.ClientChannelRegister;
import crazypants.enderio.network.NetworkUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PacketChannelList
implements IMessage,
IMessageHandler<PacketChannelList, IMessage> {
    private List<Channel> channels;

    public PacketChannelList() {
    }

    public PacketChannelList(ChannelRegister register) {
        this.channels = new ArrayList<Channel>();
        for (ChannelType type : ChannelType.values()) {
            for (Channel channel : register.getChannelsForType(type)) {
                this.channels.add(channel);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagList tagList = new NBTTagList();
        for (Channel chan : this.channels) {
            NBTTagCompound tag = new NBTTagCompound();
            chan.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a("chanList", (NBTBase)tagList);
        NetworkUtil.writeNBTTagCompound(root, buf);
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound root = NetworkUtil.readNBTTagCompound(buf);
        NBTTagList tagList = (NBTTagList)root.func_74781_a("chanList");
        this.channels = new ArrayList<Channel>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            Channel chan = Channel.readFromNBT(tag);
            if (chan == null) continue;
            this.channels.add(chan);
        }
    }

    public IMessage onMessage(PacketChannelList message, MessageContext ctx) {
        for (Channel channel : message.channels) {
            ClientChannelRegister.instance.addChannel(channel);
        }
        return null;
    }
}

