/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.network;

import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.power.IPowerInterface;
import crazypants.util.BlockCoord;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyReceptor {
    private final IPowerInterface receptor;
    private final ForgeDirection fromDir;
    private final IoMode mode;
    private final BlockCoord location;
    private final IPowerConduit conduit;

    public EnergyReceptor(TileCapBank cb, IPowerInterface receptor, ForgeDirection dir) {
        this.receptor = receptor;
        this.fromDir = dir;
        this.mode = cb.getIoMode(dir);
        this.conduit = receptor.getDelegate() instanceof IConduitBundle ? ((IConduitBundle)receptor.getDelegate()).getConduit(IPowerConduit.class) : null;
        this.location = cb.getLocation();
    }

    public IPowerConduit getConduit() {
        return this.conduit;
    }

    public IPowerInterface getReceptor() {
        return this.receptor;
    }

    public ForgeDirection getDir() {
        return this.fromDir;
    }

    public IoMode getMode() {
        return this.mode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fromDir == null ? 0 : this.fromDir.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnergyReceptor other = (EnergyReceptor)obj;
        if (this.fromDir != other.fromDir) {
            return false;
        }
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String toString() {
        return "EnergyReceptor [receptor=" + this.receptor + ", fromDir=" + this.fromDir + ", mode=" + (Object)((Object)this.mode) + ", conduit=" + this.conduit + "]";
    }
}

