/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class MagnetController
implements IEntitySelector {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ActiveMagnet mag = this.getActiveMagnet(event.player);
        if (mag != null) {
            this.doHoover(event.player);
            if (event.side == Side.SERVER && event.player.field_70170_p.func_82737_E() % 20L == 0L) {
                ItemMagnet.drainPerSecondPower(mag.item);
                event.player.field_71071_by.func_70299_a(mag.slot, mag.item);
                event.player.field_71071_by.func_70296_d();
            }
        }
    }

    private ActiveMagnet getActiveMagnet(EntityPlayer player) {
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        for (int i = 0; i < 9; ++i) {
            if (!ItemMagnet.isActive(inv[i]) || !ItemMagnet.hasPower(inv[i])) continue;
            return new ActiveMagnet(inv[i], i);
        }
        return null;
    }

    private void doHoover(EntityPlayer player) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(player.field_70165_t - (double)Config.magnetRange), (double)(player.field_70163_u - (double)Config.magnetRange), (double)(player.field_70161_v - (double)Config.magnetRange), (double)(player.field_70165_t + (double)Config.magnetRange), (double)(player.field_70163_u + (double)Config.magnetRange), (double)(player.field_70161_v + (double)Config.magnetRange));
        List interestingItems = player.field_70170_p.func_82733_a(EntityItem.class, aabb, (IEntitySelector)this);
        List xp = player.field_70170_p.func_82733_a(EntityXPOrb.class, aabb, (IEntitySelector)this);
        if (xp != null) {
            interestingItems.addAll(xp);
        }
        for (Entity entity : interestingItems) {
            double x = player.field_70165_t + 0.5 - entity.field_70165_t;
            double y = player.field_70163_u + 1.0 - entity.field_70163_u;
            double z = player.field_70161_v + 0.5 - entity.field_70161_v;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.25) {
                entity.func_70100_b_(player);
                continue;
            }
            double speed = 0.035;
            entity.field_70159_w += x / distance * speed;
            entity.field_70181_x += y * speed;
            if (y > 0.0) {
                entity.field_70181_x = 0.12;
            }
            entity.field_70179_y += z / distance * speed;
        }
    }

    public boolean func_82704_a(Entity var1) {
        return true;
    }

    private static class ActiveMagnet {
        ItemStack item;
        int slot;

        ActiveMagnet(ItemStack item, int slot) {
            this.item = item;
            this.slot = slot;
        }
    }
}

