/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractItemConduit;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.ItemConduitSubtype;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduit;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.power.ICapacitor;
import crazypants.util.Lang;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemPowerConduit
extends AbstractItemConduit {
    private static String PREFIX;
    private static String POSTFIX;
    static ItemConduitSubtype[] subtypes;

    public static ItemPowerConduit create() {
        ItemPowerConduit result = new ItemPowerConduit();
        result.init(subtypes);
        return result;
    }

    protected ItemPowerConduit() {
        super(ModObject.itemPowerConduit);
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IPowerConduit.class;
    }

    @Override
    public IConduit createConduit(ItemStack stack, EntityPlayer player) {
        return new PowerConduit(stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (PREFIX == null) {
            POSTFIX = " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
            PREFIX = Lang.localize("power.maxOutput") + " ";
        }
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        ICapacitor cap = PowerConduit.getCapacitors()[itemStack.func_77960_j()];
        list.add(PREFIX + PowerDisplayUtil.formatPower(cap.getMaxEnergyExtracted()) + POSTFIX);
    }

    @Override
    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        return true;
    }

    static {
        subtypes = new ItemConduitSubtype[]{new ItemConduitSubtype(ModObject.itemPowerConduit.name(), "enderio:itemPowerConduit"), new ItemConduitSubtype(ModObject.itemPowerConduit.name() + "Enhanced", "enderio:itemPowerConduitEnhanced"), new ItemConduitSubtype(ModObject.itemPowerConduit.name() + "Ender", "enderio:itemPowerConduitEnder")};
    }
}

