/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.position.Area;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.FishingHooks;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFisher;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFisher
extends TileEntityFactoryPowered {
    public static final int workBase = 1800;
    protected boolean _isJammed = true;
    protected byte _speed;
    protected byte _luck;
    protected int _workNeeded = 1800;
    protected float _next = Float.NaN;
    protected Random _rand = null;
    private static Field _Random_seed = null;

    public TileEntityFisher() {
        super(Machine.Fisher);
        TileEntityFisher.createHAM(this, 1);
        this.setManageSolids(true);
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this._rand == null) {
            this._rand = new Random(world.func_72905_C() ^ world.field_73012_v.nextLong());
            this._next = this._rand.nextFloat();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFisher getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFisher(this, inventoryPlayer);
    }

    @Override
    public ForgeDirection getDirectionFacing() {
        return ForgeDirection.DOWN;
    }

    @Override
    public boolean activateMachine() {
        if (this._isJammed || this.field_145850_b.func_82737_E() % 137L == 0L) {
            Area area = this._areaManager.getHarvestArea();
            int n = 0;
            for (BlockPosition blockPosition : area.getPositionsBottomFirst()) {
                if (!this.isValidBlock(blockPosition.x, blockPosition.y, blockPosition.z)) {
                    this._isJammed = true;
                    this.setIdleTicks(this.getIdleTicksMax());
                    return false;
                }
                if (this.isValidBlock(blockPosition.x, blockPosition.y - 1, blockPosition.z)) {
                    ++n;
                }
                if (blockPosition.x != this.field_145851_c | blockPosition.z != this.field_145849_e) {
                    if (this.isValidBlock(blockPosition.x - (this.field_145851_c - blockPosition.x), blockPosition.y, blockPosition.z - (this.field_145849_e - blockPosition.z))) {
                        ++n;
                    } else if (this.isFisher(blockPosition.x - (this.field_145851_c - blockPosition.x), blockPosition.y, blockPosition.z - (this.field_145849_e - blockPosition.z))) {
                        n -= 18;
                    }
                    if (this.isFisher(blockPosition.x - (this.field_145851_c - blockPosition.x), blockPosition.y, blockPosition.z)) {
                        n -= 18;
                    }
                    if (!this.isFisher(blockPosition.x, blockPosition.y, blockPosition.z - (this.field_145849_e - blockPosition.z))) continue;
                    n -= 18;
                    continue;
                }
                if (!this.isValidBlock(blockPosition.x, blockPosition.y - 2, blockPosition.z)) continue;
                ++n;
            }
            this._workNeeded = 1800 - n * 50;
            this._isJammed = false;
        }
        if (this._isJammed) {
            return false;
        }
        if (!this.incrementWorkDone()) {
            return false;
        }
        if (this.getWorkDone() > this.getWorkMax()) {
            this.doDrop(FishingHooks.getRandomFishable((Random)this._rand, (float)this._next, (int)this._luck, (int)this._speed));
            this._next = this._rand.nextFloat();
            this.setWorkDone(0);
        }
        return true;
    }

    protected boolean isFisher(int n, int n2, int n3) {
        return n2 == this.field_145848_d - 1 && (n != this.field_145851_c || n3 != this.field_145849_e) && this.field_145850_b.func_72805_g(n, this.field_145848_d, n3) == this._machine.getMeta() && this.field_145850_b.func_147439_a(n, this.field_145848_d, n3) == this._machine.getBlock();
    }

    protected boolean isValidBlock(int n, int n2, int n3) {
        if (this.isFisher(n, n2, n3)) {
            return false;
        }
        int n4 = this.field_145850_b.func_72805_g(n, n2, n3);
        if (n4 != 0) {
            return false;
        }
        Block block = this.field_145850_b.func_147439_a(n, n2, n3);
        return block.func_149667_c(Blocks.field_150355_j) || block.func_149667_c((Block)Blocks.field_150358_i);
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public int getWorkMax() {
        return this._workNeeded;
    }

    @SideOnly(value=Side.CLIENT)
    public void setWorkMax(int n) {
        this._workNeeded = n;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        if (nBTTagCompound.func_74764_b("workNeeded")) {
            this._workNeeded = nBTTagCompound.func_74762_e("workNeeded");
        }
        if (nBTTagCompound.func_74764_b("jam")) {
            this._isJammed = nBTTagCompound.func_74767_n("jam");
        }
        if (nBTTagCompound.func_74764_b("seed")) {
            this._rand = new Random(nBTTagCompound.func_74763_f("seed"));
        }
        if (nBTTagCompound.func_74764_b("next")) {
            this._next = nBTTagCompound.func_74760_g("next");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("workNeeded", this._workNeeded);
        nBTTagCompound.func_74757_a("jam", this._isJammed);
        nBTTagCompound.func_74776_a("next", this._next);
        if (_Random_seed != null) {
            try {
                nBTTagCompound.func_74772_a("seed", ((AtomicLong)_Random_seed.get(this._rand)).get());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    public int func_70302_i_() {
        return 0;
    }

    static {
        try {
            Field field = Random.class.getDeclaredField("seed");
            field.setAccessible(true);
            _Random_seed = field;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

