/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cofh.api.inventory.IInventoryConnection;
import cofh.asm.relauncher.Strippable;
import cofh.core.util.CoreUtils;
import cofh.lib.inventory.IInventoryManager;
import cofh.lib.inventory.InventoryManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiEjector;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerEjector;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityEjector
extends TileEntityFactoryInventory {
    protected boolean _lastRedstoneState;
    protected boolean _whitelist = false;
    protected boolean _matchNBT = true;
    protected boolean _ignoreDamage = true;
    protected boolean _hasItems = false;
    protected ForgeDirection[] _pullDirections = new ForgeDirection[0];

    public TileEntityEjector() {
        super(Machine.Ejector);
        this.setManageSolids(true);
        this.setCanRotate(true);
    }

    @Override
    protected void onRotate() {
        LinkedList<ForgeDirection> linkedList = new LinkedList<ForgeDirection>();
        linkedList.addAll(MFRUtil.VALID_DIRECTIONS);
        linkedList.remove(this.getDirectionFacing());
        this._pullDirections = linkedList.toArray(new ForgeDirection[5]);
        super.onRotate();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = this._rednetState != 0 || CoreUtils.isRedstonePowered((TileEntity)this);
        if (bl & !this._lastRedstoneState & (!this._whitelist | this._whitelist == this._hasItems)) {
            ForgeDirection forgeDirection = this.getDirectionFacing();
            Map<ForgeDirection, IInventory> map = UtilInventory.findChests(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this._pullDirections);
            block0: for (Map.Entry<ForgeDirection, IInventory> entry : map.entrySet()) {
                if (entry.getKey() == forgeDirection) continue;
                IInventoryManager iInventoryManager = InventoryManager.create((Object)entry.getValue(), (ForgeDirection)entry.getKey().getOpposite());
                Map map2 = iInventoryManager.getContents();
                for (Map.Entry entry2 : map2.entrySet()) {
                    ItemStack itemStack = (ItemStack)entry2.getValue();
                    if (itemStack == null || itemStack.field_77994_a < 1 || !iInventoryManager.canRemoveItem(itemStack, ((Integer)entry2.getKey()).intValue())) continue;
                    boolean bl2 = false;
                    int n = 1;
                    int n2 = this.getSizeItemList();
                    while (n2-- > 0) {
                        if (!this.itemMatches(this._inventory[n2], itemStack)) continue;
                        bl2 = true;
                        n = Math.max(1, this._inventory[n2].field_77994_a);
                        break;
                    }
                    if (this._whitelist != bl2) continue;
                    ItemStack itemStack2 = itemStack.func_77946_l();
                    itemStack2.field_77994_a = n = Math.min(itemStack.field_77994_a, n);
                    ItemStack itemStack3 = UtilInventory.dropStack((TileEntity)this, itemStack2, forgeDirection, forgeDirection);
                    if (itemStack3 != null && itemStack3.field_77994_a >= n) continue;
                    iInventoryManager.removeItem(n - (itemStack3 == null ? 0 : itemStack3.field_77994_a), itemStack2);
                    break block0;
                }
            }
        }
        this._lastRedstoneState = bl;
    }

    protected boolean itemMatches(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        if (!itemStack.func_77973_b().equals(itemStack2.func_77973_b())) {
            return false;
        }
        if (!this._ignoreDamage && !itemStack.func_77969_a(itemStack2)) {
            return false;
        }
        if (this._matchNBT) {
            if (itemStack.func_77978_p() == null && itemStack2.func_77978_p() == null) {
                return true;
            }
            if (itemStack.func_77978_p() == null || itemStack2.func_77978_p() == null) {
                return false;
            }
            return itemStack.func_77978_p().equals((Object)itemStack2.func_77978_p());
        }
        return true;
    }

    @Override
    public void onFactoryInventoryChanged() {
        int n = this.getSizeItemList();
        while (n-- > 0) {
            if (this._inventory[n] == null) continue;
            this._hasItems = true;
            return;
        }
    }

    public int getSizeItemList() {
        return 9;
    }

    public int func_70302_i_() {
        return this.getSizeItemList();
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return false;
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return false;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiEjector(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryInventory getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerEjector(this, inventoryPlayer);
    }

    @Override
    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74757_a("whitelist", this._whitelist);
        nBTTagCompound.func_74757_a("matchNBT", this._matchNBT);
        nBTTagCompound.func_74757_a("ignoreDamage", this._ignoreDamage);
    }

    @Override
    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        this._whitelist = nBTTagCompound.func_74767_n("whitelist");
        this._matchNBT = !nBTTagCompound.func_74764_b("matchNBT") || nBTTagCompound.func_74767_n("matchNBT");
        this._ignoreDamage = nBTTagCompound.func_74767_n("ignoreDamage");
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        nBTTagCompound.func_74757_a("whitelist", this._whitelist);
        nBTTagCompound.func_74757_a("matchNBT", this._matchNBT);
        nBTTagCompound.func_74757_a("ignoreDamage", this._ignoreDamage);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("redstone", this._lastRedstoneState);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this._lastRedstoneState = nBTTagCompound.func_74767_n("redstone");
        this._whitelist = nBTTagCompound.func_74767_n("whitelist");
        this._matchNBT = !nBTTagCompound.func_74764_b("matchNBT") || nBTTagCompound.func_74767_n("matchNBT");
        this._ignoreDamage = nBTTagCompound.func_74767_n("ignoreDamage");
    }

    public boolean getIsWhitelist() {
        return this._whitelist;
    }

    public boolean getIsNBTMatch() {
        return this._matchNBT;
    }

    public boolean getIsIDMatch() {
        return this._ignoreDamage;
    }

    public void setIsWhitelist(boolean bl) {
        this._whitelist = bl;
    }

    public void setIsNBTMatch(boolean bl) {
        this._matchNBT = bl;
    }

    public void setIsIDMatch(boolean bl) {
        this._ignoreDamage = bl;
    }

    @Override
    public IInventoryConnection.ConnectionType canConnectInventory(ForgeDirection forgeDirection) {
        return forgeDirection == this.getDirectionFacing() ? IInventoryConnection.ConnectionType.FORCE : IInventoryConnection.ConnectionType.DENY;
    }

    @Override
    @Strippable(value={"buildcraft.api.transport.IPipeConnection"})
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType pipeType, ForgeDirection forgeDirection) {
        if (pipeType == IPipeTile.PipeType.STRUCTURE) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        if (forgeDirection == this.getDirectionFacing()) {
            return super.overridePipeConnection(pipeType, forgeDirection);
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

