/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.init;

import com.google.common.base.Preconditions;
import com.nauktis.solarflux.SolarFluxMod;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.init.ModBlocks;
import com.nauktis.solarflux.init.ModItems;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModRecipes {
    private ModRecipes() {
    }

    public static void initialize() {
        SolarFluxMod.log.info("Registering recipes", new Object[0]);
        ModRecipes.registerCommonRecipes();
        if (!(ModConfiguration.useThermalExpansionRecipes() && Loader.isModLoaded((String)"ThermalExpansion") && ModRecipes.registerThermalExpansion())) {
            ModRecipes.registerVanilla();
        }
    }

    public static void registerCommonRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModItems.mMirror, 2), new Object[]{"ggg", " i ", Character.valueOf('g'), "blockGlass", Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCell1, new Object[]{"ggg", "lll", "mmm", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), "gemLapis", Character.valueOf('m'), ModItems.mMirror}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCell2, new Object[]{"clc", "lcl", "msm", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('l'), "gemLapis", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('s'), ModItems.mSolarCell1}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCell3, new Object[]{"ggg", "lll", "oco", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), "dustGlowstone", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('c'), ModItems.mSolarCell2}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCell4, new Object[]{"bbb", "gdg", "qcq", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), "dustGlowstone", Character.valueOf('d'), "blockDiamond", Character.valueOf('q'), "blockQuartz", Character.valueOf('c'), ModItems.mSolarCell3}));
    }

    public static void registerVanilla() {
        SolarFluxMod.log.info("Registering Vanilla recipes", new Object[0]);
        String ingotCopper = ModRecipes.getOreNameWithFallback("ingotCopper", "ingotIron");
        String ingotSilver = ModRecipes.getOreNameWithFallback("ingotSilver", "ingotIron");
        String ingotTin = ModRecipes.getOreNameWithFallback("ingotTin", "ingotIron");
        String blockCopper = ModRecipes.getOreNameWithFallback("blockCopper", "blockIron");
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCore1, new Object[]{" m ", "crc", " m ", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('c'), ingotCopper, Character.valueOf('r'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCore2, new Object[]{"ici", "crc", "ici", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), ModItems.mSolarCore1, Character.valueOf('r'), "blockRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCore3, new Object[]{"mcm", "crc", "tct", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('c'), ModItems.mSolarCore2, Character.valueOf('r'), "blockRedstone", Character.valueOf('t'), ingotTin}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCore4, new Object[]{"mcm", "cgc", "scs", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('c'), ModItems.mSolarCore3, Character.valueOf('g'), "blockGold", Character.valueOf('s'), ingotSilver}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCore5, new Object[]{"mcm", "cdc", "gcg", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('c'), ModItems.mSolarCore4, Character.valueOf('d'), "blockDiamond", Character.valueOf('g'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar1, new Object[]{"mmm", "prp", "ppp", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('p'), "plankWood", Character.valueOf('r'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar2, new Object[]{"sss", "scs", "sss", Character.valueOf('s'), ModBlocks.mSolar1, Character.valueOf('c'), ModItems.mSolarCore1}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar3, new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell1, Character.valueOf('s'), ModBlocks.mSolar2, Character.valueOf('c'), ModItems.mSolarCore2, Character.valueOf('b'), blockCopper}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar4, new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell2, Character.valueOf('s'), ModBlocks.mSolar3, Character.valueOf('c'), ModItems.mSolarCore3, Character.valueOf('b'), "blockIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar5, new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell3, Character.valueOf('s'), ModBlocks.mSolar4, Character.valueOf('c'), ModItems.mSolarCore4, Character.valueOf('b'), "blockGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar6, new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell4, Character.valueOf('s'), ModBlocks.mSolar5, Character.valueOf('c'), ModItems.mSolarCore5, Character.valueOf('b'), "blockDiamond"}));
    }

    public static boolean registerThermalExpansion() {
        SolarFluxMod.log.info("Registering %s recipes", "ThermalExpansion");
        try {
            ItemStack powerCoilGold = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"powerCoilGold", (int)1));
            ItemStack frameMachineBasic = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineBasic", (int)1));
            ItemStack frameMachineHardened = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineHardened", (int)1));
            ItemStack frameMachineReinforced = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineReinforced", (int)1));
            ItemStack frameMachineResonant = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"frameMachineResonant", (int)1));
            ItemStack cellBasic = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"cellBasic", (int)1));
            ItemStack cellHardened = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"cellHardened", (int)1));
            ItemStack cellReinforced = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"cellReinforced", (int)1));
            ItemStack cellResonant = (ItemStack)Preconditions.checkNotNull((Object)GameRegistry.findItemStack((String)"ThermalExpansion", (String)"cellResonant", (int)1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar1, new Object[]{"mmm", "prp", "ppp", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('p'), "plankWood", Character.valueOf('r'), "dustRedstone"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar2, new Object[]{"sss", "scs", "sss", Character.valueOf('s'), ModBlocks.mSolar1, Character.valueOf('c'), powerCoilGold}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar3, new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell1, Character.valueOf('s'), ModBlocks.mSolar2, Character.valueOf('c'), frameMachineBasic, Character.valueOf('b'), cellBasic}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar4, new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell2, Character.valueOf('s'), ModBlocks.mSolar3, Character.valueOf('c'), frameMachineHardened, Character.valueOf('b'), cellHardened}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar5, new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell3, Character.valueOf('s'), ModBlocks.mSolar4, Character.valueOf('c'), frameMachineReinforced, Character.valueOf('b'), cellReinforced}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModBlocks.mSolar6, new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell4, Character.valueOf('s'), ModBlocks.mSolar5, Character.valueOf('c'), frameMachineResonant, Character.valueOf('b'), cellResonant}));
            return true;
        }
        catch (NullPointerException e) {
            SolarFluxMod.log.info("Failed to register %s recipes. Cause: %s", "ThermalExpansion", e);
            return false;
        }
    }

    private static boolean knowsOre(String pName) {
        return !OreDictionary.getOres((String)pName).isEmpty();
    }

    private static String getOreNameWithFallback(String pName, String pFallback) {
        if (ModRecipes.knowsOre(pName)) {
            return pName;
        }
        SolarFluxMod.log.info("Unable to find %s, falling back on %s", pName, pFallback);
        return pFallback;
    }
}

