/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs.golem;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.utilityMobs.EffectHelper;
import toast.utilityMobs.EnumUpgrade;
import toast.utilityMobs.TargetHelper;
import toast.utilityMobs.ai.EntityAIGolemSit;
import toast.utilityMobs.colossal.EntityColossalGolem;
import toast.utilityMobs.golem.EntityLargeGolem;

public abstract class EntityUtilityGolem
extends EntityGolem
implements IEntityOwnable {
    public ResourceLocation texture = null;
    public TargetHelper targetHelper = TargetHelper.getTargetHelper(null);
    public EntityAIGolemSit sitAI = new EntityAIGolemSit(this);
    public int golemAttackTime = 0;
    public byte sinks = (byte)-1;

    public EntityUtilityGolem(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)"");
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)1);
    }

    public void setFishingRod(boolean rod) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)(rod ? 1 : 0)));
    }

    public boolean getFishingRod() {
        return this.field_70180_af.func_75683_a(21) == 1;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void func_70071_h_() {
        String owner = this.func_152113_b();
        if (this.targetHelper.destroyed() || !owner.equals(this.targetHelper.owner)) {
            this.targetHelper = TargetHelper.getTargetHelper(owner);
        }
        this.golemAttackTime = Math.max(this.golemAttackTime - 1, 0);
        super.func_70071_h_();
    }

    public ItemStack func_70694_bm() {
        if (this.field_70170_p.field_72995_K && !this.getFishingRod()) {
            return new ItemStack(Items.field_151055_y);
        }
        return super.func_70694_bm();
    }

    public boolean func_70652_k(Entity entity) {
        boolean hit;
        float attackDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entity instanceof EntityLivingBase) {
            attackDamage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (hit = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), attackDamage)) {
            this.hitEffects(entity);
            if (knockback > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            int fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
            if (this.func_71124_b(0) != null) {
                if (EffectHelper.isFireWeapon(this.func_71124_b(0))) {
                    fireAspect += 2;
                } else if (EffectHelper.isLavaWeapon(this.func_71124_b(0))) {
                    if (!entity.func_70045_F()) {
                        entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
                        fireAspect += 4;
                    }
                } else if (this.func_71124_b(0).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W)) {
                    EffectHelper.explode((Entity)this, 3.0f);
                    this.func_70062_b(0, null);
                    this.func_70106_y();
                }
            }
            if (fireAspect > 0) {
                entity.func_70015_d(fireAspect << 2);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
        }
        return hit;
    }

    public void hitEffects(Entity entity) {
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return null;
    }

    protected String func_70673_aS() {
        return null;
    }

    protected boolean func_70041_e_() {
        return true;
    }

    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150423_aK);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.dropFewItems(recentlyHit, looting, 0.0f);
    }

    protected void dropFewItems(boolean recentlyHit, int looting, float dropChance) {
        if (recentlyHit) {
            this.func_145779_a(this.func_146068_u(), 1);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        double mountRange;
        List list;
        if (!this.canInteract(player)) {
            return super.func_70085_c(player);
        }
        ItemStack playerHeld = player.func_71124_b(0);
        if (player.func_70093_af() && playerHeld != null && playerHeld.func_77973_b() instanceof ItemShears) {
            if (!this.field_70170_p.field_72995_K) {
                float health = this.func_110143_aJ();
                float maxHealth = this.func_110138_aP();
                this.dropFewItems(true, 0, health * health / maxHealth / maxHealth);
                this.func_82160_b(true, 0);
            }
            this.func_85030_a("step.stone", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.func_70656_aK();
            player.func_71038_i();
            this.func_70106_y();
        } else if (!(this instanceof EntityLargeGolem) && !(this instanceof EntityColossalGolem) && (list = this.field_70170_p.func_72872_a(EntityColossalGolem.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (mountRange = 7.0)), (double)(this.field_70163_u - mountRange), (double)(this.field_70161_v - mountRange), (double)(this.field_70165_t + mountRange), (double)(this.field_70163_u + mountRange), (double)(this.field_70161_v + mountRange)))) != null) {
            for (EntityColossalGolem golem : list) {
                if (golem.field_70153_n != null || !golem.func_110167_bD() || golem.func_110166_bE() != player) continue;
                this.func_70078_a((Entity)golem);
                break;
            }
        }
        return super.func_70085_c(player);
    }

    public boolean canInteract(EntityPlayer player) {
        if (player.func_70093_af() && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemShears) {
            return this.targetHelper.playerHasPermission(player.func_70005_c_(), this.getUsePermissions() | 4);
        }
        return this.func_70089_S() && this.targetHelper.playerHasPermission(player.func_70005_c_(), this.getUsePermissions());
    }

    public int getUsePermissions() {
        return 3;
    }

    public boolean setEquipment(ItemStack itemStack) {
        if (itemStack == null) {
            for (int slot = 0; slot < 5; ++slot) {
                if (this.func_71124_b(slot) == null) continue;
                return this.setEquipment(slot, itemStack);
            }
            return false;
        }
        int slot = 0;
        if (itemStack.func_77973_b() instanceof ItemArmor) {
            slot = 4 - ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
        }
        return this.setEquipment(slot, itemStack);
    }

    public boolean setEquipment(int slot, ItemStack itemStack) {
        if (!this.field_70170_p.field_72995_K && this.func_71124_b(slot) != null) {
            this.func_70099_a(this.func_71124_b(slot), 0.0f);
        }
        this.func_70062_b(slot, itemStack);
        this.field_82174_bp[slot] = 2.0f;
        return true;
    }

    public void doRangedAttack(EntityLivingBase target) {
        ItemStack held = this.func_71124_b(0);
        if (held == null) {
            return;
        }
        if (held.func_77973_b() instanceof ItemBow) {
            EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, 12.0f);
            this.targetHelper.setOwned((Entity)arrow);
            EnumUpgrade.DEFAULT.applyToArrow(arrow);
            this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)held);
            int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)held);
            if (power > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
            }
            if (punch > 0) {
                arrow.func_70240_a(punch);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)held) > 0) {
                arrow.func_70015_d(100);
            }
            this.field_70170_p.func_72838_d((Entity)arrow);
        } else {
            EntitySnowball snowball = new EntitySnowball(this.field_70170_p, (EntityLivingBase)this);
            this.targetHelper.setOwned((Entity)snowball);
            EnumUpgrade.DEFAULT.applyTo((Entity)snowball);
            double motionX = target.field_70165_t - this.field_70165_t;
            double motionY = target.field_70163_u + (double)target.func_70047_e() - 1.1 - snowball.field_70163_u;
            double motionZ = target.field_70161_v - this.field_70161_v;
            float velocity = (float)Math.sqrt(motionX * motionX + motionZ * motionZ) * 0.2f;
            snowball.func_70186_c(motionX, motionY + (double)velocity, motionZ, 1.6f, 12.0f);
            this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)snowball);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        this.sitAI.sit = false;
        return super.func_70097_a(damageSource, damage);
    }

    public EntityPlayer getOwner() {
        return this.field_70170_p.func_72924_a(this.func_152113_b());
    }

    public String func_152113_b() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setOwner(String username) {
        if (!this.func_152113_b().equals(username)) {
            this.field_70180_af.func_75692_b(17, (Object)(username == null ? "" : username));
            this.targetHelper = TargetHelper.getTargetHelper(username);
        }
    }

    public Team func_96124_cp() {
        EntityPlayer owner = this.getOwner();
        if (owner != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_142014_c(EntityLivingBase entity) {
        EntityPlayer owner = this.getOwner();
        if (entity == owner) {
            return true;
        }
        if (owner != null) {
            return owner.func_142014_c(entity);
        }
        if (entity instanceof EntityUtilityGolem) {
            return ((IEntityOwnable)entity).func_70902_q() == null;
        }
        return super.func_142014_c(entity);
    }

    public boolean isSitting() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_75692_b(20, (Object)(sitting ? (byte)1 : 0));
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70072_I() {
        if (this.sinks < 0) {
            return super.func_70072_I();
        }
        if (this.field_70170_p.func_72918_a(this.field_70121_D.func_72314_b(0.0, -0.4, 0.0).func_72331_e(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)this)) {
            if (this.sinks < 1) {
                float speed = (float)Math.sqrt(this.field_70159_w * this.field_70159_w * 0.2 + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * 0.2) * 0.2f;
                if (speed > 1.0f) {
                    speed = 1.0f;
                }
                this.func_85030_a("liquid.splash", speed, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                float y = (float)Math.floor(this.field_70121_D.field_72338_b);
                float i = this.field_70130_N * 20.0f + 1.0f;
                while (true) {
                    float f = i;
                    i = f - 1.0f;
                    if (!(f > 0.0f)) break;
                    float x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    float z = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t + (double)x, (double)(y + 1.0f), this.field_70161_v + (double)z, this.field_70159_w, this.field_70181_x - (double)(this.field_70146_Z.nextFloat() * 0.2f), this.field_70179_y);
                    x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    z = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                    this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)x, (double)(y + 1.0f), this.field_70161_v + (double)z, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
            this.field_70143_R = 0.0f;
            this.sinks = 1;
            this.func_70066_B();
        } else {
            this.sinks = 0;
        }
        return false;
    }

    public boolean func_70058_J() {
        if (this.sinks < 0) {
            return super.func_70058_J();
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("Sitting", this.isSitting());
        tag.func_74778_a("Owner", this.func_152113_b());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.sitAI.sit = tag.func_74767_n("Sitting");
        this.setSitting(this.sitAI.sit);
        String name = null;
        if (tag.func_74764_b("Owner")) {
            name = tag.func_74779_i("Owner");
        } else if (tag.func_74764_b("owner")) {
            name = tag.func_74779_i("owner");
        }
        if (name == "") {
            name = null;
        }
        this.setOwner(name);
    }

    public boolean canAttack(Entity target) {
        double range = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        return target != this && this.targetHelper.isValidTarget(target) && this.func_70635_at().func_75522_a(target) && range * range >= this.func_70092_e(target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v);
    }
}

