/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs.block;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.utilityMobs.block.EntityContainerGolem;
import toast.utilityMobs.network.GuiHelper;

public class EntityFurnaceGolem
extends EntityContainerGolem
implements ISidedInventory {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("UtilityMobs:textures/models/block/furnaceGolem.png"), new ResourceLocation("UtilityMobs:textures/models/block/furnaceGolem_fire.png")};
    public int burnTime = 0;
    public int itemBurnTime = 0;
    public int cookTime = 0;

    public EntityFurnaceGolem(World world) {
        super(world);
        this.texture = TEXTURES[0];
        this.field_70178_ae = true;
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + 2);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)0);
    }

    public boolean func_70027_ad() {
        return this.getBurningState();
    }

    public boolean getBurningState() {
        return this.field_70180_af.func_75683_a(30) == 1;
    }

    public void setBurningState(boolean state) {
        this.field_70180_af.func_75692_b(30, (Object)(state ? (byte)1 : 0));
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot == 2 ? false : (slot == 1 ? TileEntityFurnace.func_145954_b((ItemStack)itemStack) : true);
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 2;
            nArray = nArray2;
            nArray2[1] = 1;
        } else if (side == 1) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = 1;
        }
        return nArray;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.func_94041_b(slot, itemStack);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return side != 0 || slot != 1 || itemStack.func_77973_b() == Items.field_151133_ar;
    }

    @Override
    public int func_70302_i_() {
        return 3;
    }

    @Override
    public String func_145825_b() {
        return this.func_94056_bM() ? this.func_94057_bL() : "Furnace Golem";
    }

    @Override
    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150460_al);
    }

    @Override
    public boolean openGUI(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            GuiHelper.displayGUIFurnace(player, this);
        }
        return true;
    }

    @Override
    public int getUsePermissions() {
        return super.getUsePermissions() | 4;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.texture = this.getBurningState() ? TEXTURES[1] : TEXTURES[0];
        }
    }

    public void func_70636_d() {
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean burnState;
            if (this.burnTime == 0 && this.canSmelt()) {
                this.itemBurnTime = this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(1));
                if (this.burnTime > 0 && this.func_70301_a(1) != null) {
                    --this.func_70301_a((int)1).field_77994_a;
                    if (this.func_70301_a((int)1).field_77994_a == 0) {
                        this.func_70299_a(1, this.func_70301_a(1).func_77973_b().getContainerItem(this.func_70301_a(1)));
                    }
                }
            }
            if (this.getBurningState() && this.canSmelt()) {
                ++this.cookTime;
                if (this.cookTime == 200) {
                    this.cookTime = 0;
                    this.smeltItem();
                }
            } else {
                this.cookTime = 0;
            }
            boolean bl = burnState = this.burnTime > 0;
            if (this.getBurningState() != burnState) {
                this.setBurningState(burnState);
            }
        }
        super.func_70636_d();
    }

    public boolean canSmelt() {
        if (this.func_70301_a(0) == null) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(0));
        if (itemStack == null) {
            return false;
        }
        if (this.func_70301_a(2) == null) {
            return true;
        }
        if (!this.func_70301_a(2).func_77969_a(itemStack)) {
            return false;
        }
        int result = this.func_70301_a((int)2).field_77994_a + itemStack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemStack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(0));
            if (this.func_70301_a(2) == null) {
                this.func_70299_a(2, itemStack.func_77946_l());
            } else if (this.func_70301_a(2).func_77969_a(itemStack)) {
                this.func_70301_a((int)2).field_77994_a += itemStack.field_77994_a;
            }
            --this.func_70301_a((int)0).field_77994_a;
            if (this.func_70301_a((int)0).field_77994_a <= 0) {
                this.func_70299_a(0, null);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74777_a("BurnTime", (short)this.burnTime);
        tag.func_74777_a("CookTime", (short)this.cookTime);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.burnTime = tag.func_74765_d("BurnTime");
        this.cookTime = tag.func_74765_d("CookTime");
        this.itemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(1));
    }

    @Override
    public void takeContentsFromNBT(NBTTagCompound tag) {
        super.takeContentsFromNBT(tag);
        this.burnTime = tag.func_74765_d("BurnTime");
        this.cookTime = tag.func_74765_d("CookTime");
        this.itemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(1));
        tag.func_74777_a("BurnTime", (short)0);
        tag.func_74777_a("CookTime", (short)0);
    }
}

