/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import toast.utilityMobs.BookHelper;
import toast.utilityMobs.EffectHelper;
import toast.utilityMobs.Properties;
import toast.utilityMobs._UtilityMobs;
import toast.utilityMobs.golem.EntityUtilityGolem;
import toast.utilityMobs.network.MessageFetchTargetHelper;
import toast.utilityMobs.network.MessageTargetHelper;

public class TargetHelper {
    private static final HashMap<String, TargetHelper> TARGET_HELPERS = new HashMap();
    public static File SAVE_DIRECTORY;
    public static final byte PERMISSION_TARGET = 1;
    public static final byte PERMISSION_USE = 2;
    public static final byte PERMISSION_OPEN = 4;
    public static final byte HIGHEST_PERMISSION = 4;
    public static final boolean HOSTILE;
    public String owner;
    private boolean destroy;
    private HashMap<String, Byte> permissions = new HashMap();
    private HashSet<Class> mobBlacklist = new HashSet();
    private ArrayList<Class> mobWhitelist = new ArrayList();

    private TargetHelper(String username) {
        this.owner = username;
        TARGET_HELPERS.put(this.owner, this);
        if (this.owner != null) {
            if (this.hasSave()) {
                this.load();
            } else {
                this.setPermissions(this.owner, 7);
                this.whitelist(EntityPlayer.class);
                this.whitelist(EntityUtilityGolem.class);
                this.whitelist(EntitySilverfish.class);
                this.whitelist(EntitySkeleton.class);
                this.whitelist(EntitySlime.class);
                this.whitelist(EntitySpider.class);
                this.whitelist(EntityWitch.class);
                this.whitelist(EntityZombie.class);
            }
        }
    }

    public static TargetHelper getTargetHelper(String owner) {
        TargetHelper targetHelper;
        if (owner == "") {
            owner = null;
        }
        if ((targetHelper = TARGET_HELPERS.get(owner)) == null) {
            targetHelper = new TargetHelper(owner);
        }
        return targetHelper;
    }

    public static boolean hasOwner(Entity entity) {
        return entity.getEntityData().func_74764_b("UM|owner");
    }

    public static TargetHelper getOwnerTargetHelper(Entity entity) {
        return TargetHelper.getTargetHelper(entity.getEntityData().func_74779_i("UM|owner"));
    }

    public EntityPlayer getOwner() {
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            EntityPlayer player = world.func_72924_a(this.owner);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    public void setOwned(Entity entity) {
        if (this.owner != null) {
            entity.getEntityData().func_74778_a("UM|owner", this.owner);
        }
    }

    public boolean canDamagePlayer(String username) {
        if (HOSTILE) {
            return true;
        }
        if (!this.permissions.containsKey(username)) {
            return !this.isBlacklisted(EntityPlayer.class) && this.isWhitelisted(EntityPlayer.class);
        }
        return (this.permissions.get(username) & 1) == 0;
    }

    public byte getPermissions(String username) {
        if (this.owner == null || !this.permissions.containsKey(username)) {
            return 0;
        }
        return this.permissions.get(username);
    }

    public boolean playerHasPermission(String username, int value) {
        return this.owner == null || (this.getPermissions(username) & value) == value;
    }

    public boolean maintainTarget(Entity entity) {
        return entity instanceof EntityLivingBase && entity.func_70089_S();
    }

    public boolean isValidTarget(Entity entity) {
        if (!this.maintainTarget(entity)) {
            return false;
        }
        if (this.owner == null) {
            return entity instanceof EntityUtilityGolem ? ((IEntityOwnable)entity).func_70902_q() != null : true;
        }
        if (entity instanceof IEntityOwnable && (this.owner.equals(((IEntityOwnable)entity).func_152113_b()) || !this.canDamagePlayer(((IEntityOwnable)entity).func_152113_b()))) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            return this.canDamagePlayer(((EntityPlayer)entity).func_70005_c_());
        }
        Class<?> entityClass = entity.getClass();
        return !this.isBlacklisted(entityClass) && this.isWhitelisted(entityClass);
    }

    public static void destroyAll() {
        for (Map.Entry<String, TargetHelper> entry : TARGET_HELPERS.entrySet()) {
            entry.getValue().softDestroy();
        }
        TARGET_HELPERS.clear();
    }

    private void softDestroy() {
        this.destroy = true;
    }

    public void destroy() {
        this.destroy = true;
        TARGET_HELPERS.remove(this);
    }

    public boolean destroyed() {
        return this.destroy;
    }

    public void setPermissions(String username, int value) {
        if (value > 0) {
            this.permissions.put(username, (byte)value);
        } else {
            this.permissions.remove(username);
        }
    }

    public void addPermissions(String username, int value) {
        if (this.permissions.containsKey(username)) {
            byte prev = this.permissions.get(username);
            value |= prev;
        }
        this.permissions.put(username, (byte)value);
    }

    public void remPermissions(String username, int value) {
        if (this.permissions.containsKey(username)) {
            byte prev = this.permissions.get(username);
            if ((prev = (byte)(prev & ~value)) > 0) {
                this.permissions.put(username, prev);
            } else {
                this.permissions.remove(username);
            }
        }
    }

    public void blacklist(Class entityClass) {
        if (!this.isBlacklisted(entityClass) && this.isWhitelisted(entityClass)) {
            this.mobBlacklist.add(entityClass);
        }
    }

    public void unblacklist(Class entityClass) {
        this.mobBlacklist.remove(entityClass);
    }

    public void toggleBlacklist(Class entityClass) {
        if (this.isBlacklisted(entityClass)) {
            this.unblacklist(entityClass);
        } else {
            this.blacklist(entityClass);
        }
    }

    public void whitelist(Class entityClass) {
        if (!this.mobWhitelist.contains(entityClass) && EntityLivingBase.class.isAssignableFrom(entityClass) && this.clearWhitelistFor(entityClass)) {
            this.mobWhitelist.add(entityClass);
        }
    }

    public void unwhitelist(Class entityClass) {
        this.clearBlacklistFor(entityClass);
        this.mobWhitelist.remove(entityClass);
    }

    public void toggleWhitelist(Class entityClass) {
        if (this.mobWhitelist.contains(entityClass)) {
            this.unwhitelist(entityClass);
        } else {
            this.whitelist(entityClass);
        }
    }

    public boolean isWhitelisted(Class entityClass) {
        for (Class allowedClass : this.mobWhitelist) {
            if (!allowedClass.isAssignableFrom(entityClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklisted(Class entityClass) {
        return this.mobBlacklist.contains(entityClass);
    }

    private boolean clearWhitelistFor(Class entityClass) {
        Class allowedClass;
        Iterator<Class> iterator = this.mobWhitelist.iterator();
        while (iterator.hasNext() && (allowedClass = iterator.next()) != null) {
            if (allowedClass.isAssignableFrom(entityClass)) {
                return false;
            }
            if (!entityClass.isAssignableFrom(allowedClass)) continue;
            iterator.remove();
        }
        return true;
    }

    private void clearBlacklistFor(Class entityClass) {
        Class disallowedClass;
        Iterator<Class> iterator = this.mobBlacklist.iterator();
        while (iterator.hasNext() && (disallowedClass = iterator.next()) != null) {
            if (!entityClass.isAssignableFrom(disallowedClass)) continue;
            iterator.remove();
        }
    }

    public boolean hasSave() {
        if (this.owner == null) {
            return false;
        }
        try {
            return new File(SAVE_DIRECTORY, this.owner + ".txt").exists();
        }
        catch (Exception ex) {
            _UtilityMobs.console("Failed to fetch target save data (" + this.owner + ".txt)!");
            ex.printStackTrace();
            return false;
        }
    }

    public void save() {
        if (this.owner == null || this.destroyed()) {
            return;
        }
        this.updateTargetHelper();
        try {
            File saveTmp = new File(SAVE_DIRECTORY, this.owner + ".txt.tmp");
            File save = new File(SAVE_DIRECTORY, this.owner + ".txt");
            SAVE_DIRECTORY.mkdirs();
            saveTmp.createNewFile();
            FileWriter out = new FileWriter(saveTmp);
            out.write("player_permissions");
            for (Map.Entry<String, Byte> entry : this.permissions.entrySet()) {
                out.write("\n" + Integer.toBinaryString(entry.getValue().intValue()) + " " + entry.getKey());
            }
            out.write("\n\nwhitelist");
            for (Class entityClass : this.mobWhitelist) {
                out.write("\n" + TargetHelper.classToString(entityClass));
            }
            out.write("\n\nblacklist");
            for (Class entityClass : this.mobBlacklist) {
                out.write("\n" + TargetHelper.classToString(entityClass));
            }
            out.close();
            save.delete();
            saveTmp.renameTo(save);
        }
        catch (Exception ex) {
            _UtilityMobs.console("Failed to save target data (" + this.owner + ".txt)!");
            ex.printStackTrace();
        }
    }

    public void save(ByteBuf buf) {
        if (this.owner == null || this.destroyed()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
            return;
        }
        String list = "";
        for (Map.Entry<String, Byte> entry : this.permissions.entrySet()) {
            list = list + "\n" + Integer.toBinaryString(entry.getValue().intValue()) + " " + entry.getKey();
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)list);
        list = "";
        for (Class entityClass : this.mobWhitelist) {
            list = list + "\n" + TargetHelper.classToString(entityClass);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)list);
        list = "";
        for (Class entityClass : this.mobBlacklist) {
            list = list + "\n" + TargetHelper.classToString(entityClass);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)list);
    }

    public void load() {
        if (this.owner == null || this.destroyed()) {
            return;
        }
        try {
            int dat;
            this.permissions.clear();
            this.mobBlacklist.clear();
            this.mobWhitelist.clear();
            File save = new File(SAVE_DIRECTORY, this.owner + ".txt");
            if (!save.exists()) {
                return;
            }
            FileInputStream in = new FileInputStream(save);
            boolean status = false;
            String key = "";
            String value = "";
            while ((dat = in.read()) >= 0) {
                if (dat == 13) continue;
                if (dat == 10) {
                    if (!status) {
                        if (key == "") continue;
                        if (!(key.equalsIgnoreCase("player_permissions") || key.equalsIgnoreCase("whitelist") || key.equalsIgnoreCase("blacklist"))) {
                            _UtilityMobs.console("Unrecognized value in player config: " + key + " (" + this.owner + ".txt)!");
                            key = "";
                            continue;
                        }
                        status = true;
                        continue;
                    }
                    if (!status) continue;
                    if (value == "") {
                        key = "";
                        status = false;
                        continue;
                    }
                    if (key.equalsIgnoreCase("player_permissions")) {
                        for (int i = 0; i < value.length(); ++i) {
                            if (value.charAt(i) != ' ') continue;
                            try {
                                this.setPermissions(value.substring(i + 1), Integer.parseInt(value.substring(0, i), 2));
                                continue;
                            }
                            catch (Exception ex) {
                                _UtilityMobs.console("Invalid player permissions entry: " + value + " (" + this.owner + ".txt)!");
                            }
                        }
                    } else if (key.equalsIgnoreCase("whitelist")) {
                        Class entry = TargetHelper.stringToClass(value);
                        if (entry == null) {
                            _UtilityMobs.console("Invalid whitelist entry: " + value + " (" + this.owner + ".txt)!");
                        } else {
                            this.whitelist(entry);
                        }
                    } else if (key.equalsIgnoreCase("blacklist")) {
                        Class entry = TargetHelper.stringToClass(value);
                        if (entry == null) {
                            _UtilityMobs.console("Invalid blacklist entry: " + value + " (" + this.owner + ".txt)!");
                        } else {
                            this.blacklist(entry);
                        }
                    }
                    value = "";
                    continue;
                }
                if (!status) {
                    key = key + Character.toString((char)dat);
                    continue;
                }
                if (!status) continue;
                value = value + Character.toString((char)dat);
            }
            in.close();
        }
        catch (Exception ex) {
            _UtilityMobs.console("Failed to load target data (" + this.owner + ".txt)!");
            ex.printStackTrace();
        }
    }

    public void load(ByteBuf buf) {
        if (this.owner == null || this.destroyed()) {
            return;
        }
        try {
            this.permissions.clear();
            this.mobBlacklist.clear();
            this.mobWhitelist.clear();
            String list = "";
            list = list + "player_permissions" + ByteBufUtils.readUTF8String((ByteBuf)buf);
            list = list + "\n\nwhitelist" + ByteBufUtils.readUTF8String((ByteBuf)buf);
            list = list + "\n\nblacklist" + ByteBufUtils.readUTF8String((ByteBuf)buf);
            boolean status = false;
            String key = "";
            String value = "";
            for (char dat : list.toCharArray()) {
                if (dat == '\r') continue;
                if (dat == '\n') {
                    if (!status) {
                        if (key == "") continue;
                        if (!(key.equalsIgnoreCase("player_permissions") || key.equalsIgnoreCase("whitelist") || key.equalsIgnoreCase("blacklist"))) {
                            _UtilityMobs.console("Unrecognized value in player config: " + key + " (" + this.owner + " packet)!");
                            key = "";
                            continue;
                        }
                        status = true;
                        continue;
                    }
                    if (!status) continue;
                    if (value == "") {
                        key = "";
                        status = false;
                        continue;
                    }
                    if (key.equalsIgnoreCase("player_permissions")) {
                        for (int i = 0; i < value.length(); ++i) {
                            if (value.charAt(i) != ' ') continue;
                            try {
                                this.setPermissions(value.substring(i + 1), Integer.parseInt(value.substring(0, i), 2));
                                continue;
                            }
                            catch (Exception ex) {
                                _UtilityMobs.console("Invalid player permissions entry: " + value + " (" + this.owner + " packet)!");
                            }
                        }
                    } else if (key.equalsIgnoreCase("whitelist")) {
                        Class entry = TargetHelper.stringToClass(value);
                        if (entry == null) {
                            _UtilityMobs.console("Invalid whitelist entry: " + value + " (" + this.owner + " packet)!");
                        } else {
                            this.whitelist(entry);
                        }
                    } else if (key.equalsIgnoreCase("blacklist")) {
                        Class entry = TargetHelper.stringToClass(value);
                        if (entry == null) {
                            _UtilityMobs.console("Invalid blacklist entry: " + value + " (" + this.owner + " packet)!");
                        } else {
                            this.blacklist(entry);
                        }
                    }
                    value = "";
                    continue;
                }
                if (!status) {
                    key = key + Character.toString(dat);
                    continue;
                }
                if (!status) continue;
                value = value + Character.toString(dat);
            }
            this.save();
        }
        catch (Exception ex) {
            _UtilityMobs.console("Failed to load target data (" + this.owner + " packet)!");
            ex.printStackTrace();
        }
    }

    public static ItemStack book(int id) {
        ItemStack book = new ItemStack(Items.field_151099_bA);
        BookHelper.addPages((ItemStack)book, (String[])new String[]{""}).field_77990_d.func_74774_a("umt", (byte)id);
        if (id == 0) {
            EffectHelper.setItemName(book, 11, "Player Permissions");
        } else if (id == 1) {
            EffectHelper.setItemName(book, 11, "Mob Target List");
        }
        EffectHelper.setItemGlowing(book);
        return book;
    }

    public static ItemStack write(String username, int id) {
        return TargetHelper.write(username, new ItemStack(id == 0 ? Items.field_151099_bA : Items.field_151164_bB), id);
    }

    public static ItemStack write(String username, ItemStack book, int id) {
        return TargetHelper.getTargetHelper(username).writeTo(book, id);
    }

    private ItemStack writeTo(ItemStack book, int id) {
        if (book == null) {
            return null;
        }
        BookHelper.removePages(book);
        if (id == 0) {
            book.func_150996_a(Items.field_151099_bA);
            EffectHelper.setItemName(book, 11, "Player Permissions");
            EffectHelper.setItemText(book, 7, "by " + this.owner);
            EffectHelper.setItemGlowing(book);
            BookHelper.addPages(book, " \u00a77Player Permissions\u00a70\n\nTo change a player's permissions, simply add a new line with the permissions you want that player to have - any previous lines will be overwritten when the book is saved.\nTo save any changes, simply craft this book by itself.", " \u00a77Player Permissions\u00a70\n\nIf you do not save your changes, they will be erased the next time this book is right clicked!\n\nYou may also modify permissions by right clicking a player with this book, much like the Mob Target List.", " \u00a77Player Permissions\u00a70\n\nRight clicking a player will grant that player the lowest permission he or she does not have.\n\nIf you are sneaking, instead it will remove the highest permission that player has!", " \u00a77Quick Permission Guide\n\nid:                    name\u00a70\n\n000:                 none\n\n001:               target\n\n010:                   use\n\n100:                 open\n");
            if (this.permissions.size() <= 0) {
                BookHelper.addPages(book, " \u00a7lPermissions:\u00a7r\n<no permissions>");
            } else {
                String[] pages = new String[this.permissions.size()];
                int page = 0;
                int line = 1;
                pages[0] = " \u00a7lPermissions:\u00a7r\n";
                for (Map.Entry<String, Byte> entry : this.permissions.entrySet()) {
                    int n = line;
                    line = (byte)(line + 1);
                    if (n == 10) {
                        line = 0;
                        pages[++page] = "";
                    }
                    int n2 = page;
                    pages[n2] = pages[n2] + Integer.toBinaryString(entry.getValue().intValue()) + " " + entry.getKey() + "\n";
                }
                BookHelper.addPages(book, pages);
            }
        } else if (id == 1) {
            book.func_150996_a(Items.field_151099_bA);
            EffectHelper.setItemName(book, 11, "Mob Target List");
            EffectHelper.setItemText(book, 7, "by " + this.owner);
            EffectHelper.setItemGlowing(book);
            BookHelper.addPages(book, " \u00a77Mob Target List\u00a70\n\nTo change your target list, simply add a new line with the entity you want to toggle - no need to delete lines.\nAn entity starting with '!' will NOT be targeted.\nTo save any changes, simply craft this book by itself.", " \u00a77Mob Target List\u00a70\n\nIf you do not save your changes, they will be erased the next time this book is right clicked!\nYou may also toggle entities by right clicking them.", " \u00a77Mob Target List\u00a70\n\nIf you right click while sneaking, the entity will be toggled with a '!'.\nOtherwise, it will be toggled normally.");
            if (this.mobWhitelist.size() + this.mobBlacklist.size() <= 0) {
                BookHelper.addPages(book, " \u00a7lTarget List:\u00a7r\n<no entries>");
            } else {
                String[] pages = new String[(int)Math.ceil(this.mobWhitelist.size() + this.mobBlacklist.size() / 10)];
                int page = 0;
                int line = 1;
                pages[0] = " \u00a7lTarget List:\u00a7r\n";
                for (Class entityClass : this.mobWhitelist) {
                    int n = line;
                    line = (byte)(line + 1);
                    if (n == 10) {
                        line = 0;
                        pages[++page] = "";
                    }
                    int n3 = page;
                    pages[n3] = pages[n3] + TargetHelper.classToString(entityClass) + "\n";
                }
                for (Class entityClass : this.mobBlacklist) {
                    if ((line = (int)((byte)(line + 1))) == 10) {
                        line = 0;
                        pages[++page] = "";
                    }
                    int n = page;
                    pages[n] = pages[n] + "!" + TargetHelper.classToString(entityClass) + "\n";
                }
                BookHelper.addPages(book, pages);
            }
        }
        book.field_77990_d.func_74774_a("umt", (byte)id);
        return book;
    }

    public static void read(String username, ItemStack book) {
        TargetHelper.getTargetHelper(username).readFrom(book);
    }

    private void readFrom(ItemStack book) {
        if (book == null || book.field_77990_d == null || !book.field_77990_d.func_74764_b("pages")) {
            return;
        }
        NBTTagList pages = book.field_77990_d.func_150295_c("pages", (int)new NBTTagString().func_74732_a());
        byte id = book.field_77990_d.func_74771_c("umt");
        if (id == 0) {
            this.permissions.clear();
            for (int p = 0; p < pages.func_74745_c(); ++p) {
                int index;
                String page = pages.func_150307_f(p);
                while ((index = page.indexOf("\n")) >= 0) {
                    String line = page.substring(0, index);
                    page = page.substring(index + 1);
                    this.readPermissionsLine(line);
                }
                this.readPermissionsLine(page);
            }
        } else if (id == 1) {
            this.mobBlacklist.clear();
            this.mobWhitelist.clear();
            for (int p = 0; p < pages.func_74745_c(); ++p) {
                int index;
                String page = pages.func_150307_f(p);
                while ((index = page.indexOf("\n")) >= 0) {
                    String line = page.substring(0, index);
                    page = page.substring(index + 1);
                    this.readTargetListLine(line);
                }
                this.readTargetListLine(page);
            }
        }
        this.writeTo(book, id);
        this.save();
    }

    private void readPermissionsLine(String line) {
        int index = line.indexOf(" ");
        if (index <= 0) {
            return;
        }
        try {
            byte permission = (byte)Math.max(0, Integer.parseInt(line.substring(0, index), 2));
            String username = line.substring(index + 1);
            if (username.indexOf(" ") < 0) {
                this.setPermissions(username, permission);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readTargetListLine(String line) {
        if (line.contains(" ")) {
            return;
        }
        boolean blacklist = line.startsWith("!");
        if (blacklist) {
            line = line.substring(1);
        }
        try {
            Class entry = TargetHelper.stringToClass(line);
            if (entry != null) {
                if (blacklist) {
                    this.toggleBlacklist(entry);
                } else {
                    this.toggleWhitelist(entry);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void interact(String username, ItemStack book, int id, EntityLivingBase entity, boolean sneaking) {
        TargetHelper.getTargetHelper(username).interactWith(book, id, entity, sneaking);
    }

    private void interactWith(ItemStack book, int id, EntityLivingBase entity, boolean sneaking) {
        if (id == 0) {
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            byte playerPermissions = this.getPermissions(((EntityPlayer)entity).func_70005_c_());
            if (sneaking) {
                if (playerPermissions > 0) {
                    for (int permission = 4; permission > 0; permission = (int)((byte)(permission >> 1))) {
                        if ((permission & playerPermissions) <= 0) continue;
                        this.remPermissions(((EntityPlayer)entity).func_70005_c_(), permission);
                        this.save();
                        break;
                    }
                }
            } else {
                for (int permission = 1; permission <= 4; permission = (int)((byte)(permission << 1))) {
                    if ((permission & playerPermissions) != 0) continue;
                    this.addPermissions(((EntityPlayer)entity).func_70005_c_(), permission);
                    this.save();
                    break;
                }
            }
        } else if (id == 1) {
            if (sneaking) {
                this.toggleBlacklist(entity.getClass());
            } else {
                this.toggleWhitelist(entity.getClass());
            }
            this.save();
        }
        this.writeTo(book, id);
    }

    public static void fetchTargetHelpers(EntityPlayer player) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER && player instanceof EntityPlayerMP) {
            _UtilityMobs.CHANNEL.sendTo((IMessage)new MessageFetchTargetHelper(), (EntityPlayerMP)player);
            for (Map.Entry<String, TargetHelper> entry : TARGET_HELPERS.entrySet()) {
                if (entry.getKey() == null || entry.getValue().destroyed()) continue;
                _UtilityMobs.CHANNEL.sendTo((IMessage)new MessageTargetHelper(entry.getValue()), (EntityPlayerMP)player);
            }
        }
    }

    private void updateTargetHelper() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance() == null && this.owner != null && this.owner.equals(_UtilityMobs.proxy.getPlayer())) {
                _UtilityMobs.CHANNEL.sendToServer((IMessage)new MessageTargetHelper(this));
            }
        } else {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server != null) {
                for (WorldServer world : server.field_71305_c) {
                    for (Object entity : new ArrayList(world.field_73010_i)) {
                        if (!(entity instanceof EntityPlayerMP) || this.owner.equals(((EntityPlayerMP)entity).func_70005_c_())) continue;
                        _UtilityMobs.CHANNEL.sendTo((IMessage)new MessageTargetHelper(this), (EntityPlayerMP)entity);
                    }
                }
            }
        }
    }

    private static String classToString(Class entityClass) {
        String name = null;
        if (entityClass == EntityPlayer.class) {
            name = "Player";
        } else {
            try {
                name = (String)EntityList.field_75626_c.get(entityClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (name == null) {
                name = entityClass.getName();
            }
        }
        return name;
    }

    private static Class stringToClass(String line) {
        Class<?> entityClass = null;
        if (line.equals("Player")) {
            entityClass = EntityPlayer.class;
        } else {
            try {
                entityClass = (Class<?>)EntityList.field_75625_b.get(line);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (entityClass == null) {
                try {
                    entityClass = Class.forName(line);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return entityClass;
    }

    static {
        HOSTILE = Properties.getBoolean("_general", "hostile");
    }
}

