/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import toast.utilityMobs.EffectHelper;
import toast.utilityMobs.EnumUpgrade;
import toast.utilityMobs.Properties;
import toast.utilityMobs.TargetHelper;

public class EventHandler {
    private static final int SKULL_RARITY = Properties.getInt("_general", "skull_rarity");
    private static final int CREEPER_RARITY = Properties.getInt("_general", "creeper_head_rarity");

    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDrops(LivingDropsEvent event) {
        if (SKULL_RARITY > 0 && event.entityLiving != null && !event.entityLiving.field_70170_p.field_72995_K && event.recentlyHit && event.entityLiving instanceof EntitySkeleton && ((EntitySkeleton)event.entityLiving).func_82202_m() != 1) {
            int rarity = SKULL_RARITY - event.lootingLevel;
            if (rarity <= 0 || event.entityLiving.func_70681_au().nextInt(rarity) == 0) {
                EntityItem drop = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, new ItemStack(Items.field_151144_bL));
                drop.field_145804_b = 10;
                event.drops.add(drop);
            }
        } else if (CREEPER_RARITY > 0 && event.entityLiving != null && !event.entityLiving.field_70170_p.field_72995_K && event.recentlyHit && event.entityLiving instanceof EntityCreeper) {
            int rarity = CREEPER_RARITY - event.lootingLevel;
            if (((EntityCreeper)event.entityLiving).func_70830_n()) {
                rarity >>= 1;
            }
            if (rarity <= 0 || event.entityLiving.func_70681_au().nextInt(rarity) == 0) {
                EntityItem drop = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, new ItemStack(Items.field_151144_bL, 1, 4));
                drop.field_145804_b = 10;
                event.drops.add(drop);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.source != null) {
            Entity attacker = null;
            attacker = event.source.func_76364_f();
            if (attacker instanceof EntityArrow || attacker instanceof IProjectile || attacker instanceof EntityFireball) {
                TargetHelper targetHelper;
                if (TargetHelper.hasOwner(attacker) && !(targetHelper = TargetHelper.getOwnerTargetHelper(attacker)).isValidTarget((Entity)event.entityLiving)) {
                    event.setCanceled(true);
                    return;
                }
                if (EnumUpgrade.MULTISHOT.isApplied(attacker)) {
                    event.entityLiving.field_70172_ad = 0;
                }
                if (EnumUpgrade.POISON.isApplied(attacker)) {
                    EffectHelper.stackEffect(event.entityLiving, Potion.field_76436_u, 60, 0, 1);
                }
                if (EnumUpgrade.SLOW.isApplied(attacker)) {
                    EffectHelper.stackEffect(event.entityLiving, Potion.field_76421_d, 60, 0, 4);
                }
                if (EnumUpgrade.EXPLOSIVE.isApplied(attacker)) {
                    EffectHelper.explodeSafe(attacker, 1.0f);
                }
                if (EnumUpgrade.FIRE_EXPLOSIVE.isApplied(attacker)) {
                    EffectHelper.explodeFireSafe(attacker, 1.0f);
                }
                if (EnumUpgrade.EGG.isApplied(attacker) && !event.entityLiving.field_70170_p.field_72995_K && attacker instanceof EntityArrow && !(event.entityLiving instanceof EntityPlayer) && !(event.entityLiving instanceof IBossDisplayData) && (double)event.entityLiving.func_110143_aJ() < ((EntityArrow)attacker).func_70242_d() * 2.0) {
                    EntityChicken chicken = new EntityChicken(event.entityLiving.field_70170_p);
                    chicken.func_70012_b(event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, event.entityLiving.field_70177_z, event.entityLiving.field_70125_A);
                    event.entityLiving.field_70170_p.func_72838_d((Entity)chicken);
                    event.entityLiving.func_70106_y();
                }
            }
        }
    }
}

