/*
 * Decompiled with CFR 0.152.
 */
package toast.utilityMobs;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.Explosion;
import toast.utilityMobs._UtilityMobs;
import toast.utilityMobs.network.MessageExplosion;

public abstract class EffectHelper {
    public static void clearAI(EntityLiving entity) {
        EntityAITasks.EntityAITaskEntry[] oldAI = entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0]);
        int length = oldAI.length;
        for (int i = 0; i < length; ++i) {
            entity.field_70714_bg.func_85156_a(oldAI[i].field_75733_a);
        }
    }

    public static void stackEffect(EntityLivingBase entity, Potion potion, int duration, int amplifier) {
        if (entity.func_70644_a(potion)) {
            PotionEffect potionEffect = entity.func_70660_b(potion);
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, Math.max(duration, potionEffect.func_76459_b()), potionEffect.func_76458_c() + amplifier + 1));
        } else {
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, duration, amplifier));
        }
    }

    public static void stackEffect(EntityLivingBase entity, Potion potion, int duration, int amplifier, int amplifierMax) {
        if (amplifierMax < 0) {
            EffectHelper.stackEffect(entity, potion, duration, amplifier);
            return;
        }
        if (entity.func_70644_a(potion)) {
            PotionEffect potionEffect = entity.func_70660_b(potion);
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, Math.max(duration, potionEffect.func_76459_b()), Math.min(amplifierMax, potionEffect.func_76458_c() + amplifier + 1)));
        } else if (amplifier >= 0) {
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, duration, Math.min(amplifier, amplifierMax)));
        }
    }

    public static void setItemGlowing(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_74764_b("ench")) {
            itemStack.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
    }

    public static void setItemName(ItemStack itemStack, int rarityColor, String name) {
        EffectHelper.setItemName(itemStack, "\u00a7" + Integer.toHexString(rarityColor) + name);
    }

    public static void setItemName(ItemStack itemStack, String name) {
        if (itemStack != null) {
            itemStack.func_151001_c(name);
        }
    }

    public static void clearItemText(ItemStack itemStack) {
        if (itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b("display")) {
            itemStack.field_77990_d.func_74775_l("display").func_82580_o("Lore");
        }
    }

    public static void setItemText(ItemStack itemStack, int rarityColor, String ... text) {
        EffectHelper.clearItemText(itemStack);
        EffectHelper.addItemText(itemStack, rarityColor, text);
    }

    public static void setItemText(ItemStack itemStack, String ... text) {
        EffectHelper.clearItemText(itemStack);
        EffectHelper.addItemText(itemStack, text);
    }

    public static void addItemText(ItemStack itemStack, int rarityColor, String ... text) {
        String color = "\u00a7" + Integer.toHexString(rarityColor);
        int i = text.length;
        while (i-- > 0) {
            text[i] = color + text[i];
        }
        EffectHelper.addItemText(itemStack, text);
    }

    public static void addItemText(ItemStack itemStack, String ... text) {
        NBTTagCompound displayTag;
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_74764_b("display")) {
            itemStack.field_77990_d.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(displayTag = itemStack.field_77990_d.func_74775_l("display")).func_74764_b("Lore")) {
            displayTag.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        NBTTagList lore = displayTag.func_150295_c("Lore", (int)new NBTTagString().func_74732_a());
        for (int i = 0; i < text.length; ++i) {
            lore.func_74742_a((NBTBase)new NBTTagString(text[i]));
        }
    }

    public static void overrideEnchantment(ItemStack itemStack, Enchantment enchantment, int level) {
        NBTTagCompound enchTag;
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_74764_b("ench")) {
            itemStack.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList enchList = (NBTTagList)itemStack.field_77990_d.func_74781_a("ench");
        int i = enchList.func_74745_c();
        while (i-- > 0) {
            enchTag = enchList.func_150305_b(i);
            if (enchTag.func_74765_d("id") != enchantment.field_77352_x) continue;
            enchTag.func_74777_a("lvl", (short)((byte)level));
            return;
        }
        enchTag = new NBTTagCompound();
        enchTag.func_74777_a("id", (short)enchantment.field_77352_x);
        enchTag.func_74777_a("lvl", (short)((byte)level));
        enchList.func_74742_a((NBTBase)enchTag);
    }

    public static void enchantItem(ItemStack itemStack, Enchantment enchantment, int level) {
        itemStack.func_77966_a(enchantment, level);
    }

    public static void enchantItem(ItemStack itemStack, int enchantmentID, int level) {
        EffectHelper.enchantItem(itemStack, Enchantment.field_77331_b[enchantmentID], level);
    }

    public static boolean enchantItem(ItemStack itemStack, int level) {
        return EffectHelper.enchantItem(_UtilityMobs.random, itemStack, level);
    }

    public static boolean enchantItem(Random random, ItemStack itemStack, int level) {
        if (level <= 0 || itemStack == null || !itemStack.func_77956_u()) {
            return false;
        }
        EnchantmentHelper.func_77504_a((Random)random, (ItemStack)itemStack, (int)level);
        return true;
    }

    public static boolean dye(ItemStack itemStack, String colorName) {
        int i = ItemDye.field_150922_c.length;
        while (i-- > 0) {
            if (!colorName.equalsIgnoreCase(ItemDye.field_150921_b[i])) continue;
            return EffectHelper.dye(itemStack, (byte)i);
        }
        _UtilityMobs.debugException("Tried to dye with an invalid dye name (" + colorName + ")! Valid dye names: black, red, green, brown, blue, purple, cyan, silver, gray, pink, lime, yellow, lightBlue, magenta, orange, white.");
        return false;
    }

    public static boolean dye(ItemStack itemStack, byte colorIndex) {
        if (colorIndex < 0 || colorIndex >= ItemDye.field_150922_c.length) {
            _UtilityMobs.debugException("Tried to dye with an invalid dye index (" + colorIndex + ")!");
            return false;
        }
        float[] rgb = EntitySheep.field_70898_d[BlockColored.func_150031_c((int)colorIndex)];
        return EffectHelper.dye(itemStack, (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
    }

    public static boolean dye(ItemStack itemStack, int red, int green, int blue) {
        if (red > 255 || green > 255 || blue > 255 || red < 0 || green < 0 || blue < 0) {
            _UtilityMobs.debugException("Tried to dye with an invalid RGB value (" + red + ", " + green + ", " + blue + ")!");
            return false;
        }
        return EffectHelper.dye(itemStack, (red << 16) + (green << 8) + blue);
    }

    public static boolean dye(ItemStack itemStack, int color) {
        if (color < 0 || color > 0xFFFFFF) {
            _UtilityMobs.debugException("Tried to dye with an invalid color value (" + color + ")!");
            return false;
        }
        try {
            ((ItemArmor)itemStack.func_77973_b()).func_82813_b(itemStack, color);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean isFireWeapon(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == Items.field_151033_d || itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150480_ab);
    }

    public static boolean isLavaWeapon(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == Items.field_151129_at || itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150353_l);
    }

    public static Explosion explosion(Entity exploder, float power) {
        Explosion explosion = new Explosion(exploder.field_70170_p, exploder, exploder.field_70165_t, exploder.field_70163_u, exploder.field_70161_v, power);
        explosion.field_82755_b = exploder.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        return explosion;
    }

    public static Explosion explode(Entity exploder, float power) {
        return EffectHelper.explode(EffectHelper.explosion(exploder, power));
    }

    public static Explosion explode(Explosion explosion) {
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        if (!explosion.field_77283_e.field_70170_p.field_72995_K) {
            _UtilityMobs.CHANNEL.sendToDimension((IMessage)new MessageExplosion(explosion), explosion.field_77283_e.field_71093_bK);
        }
        return explosion;
    }

    public static Explosion explodeFire(Entity exploder, float power) {
        return EffectHelper.explodeFire(EffectHelper.explosion(exploder, power));
    }

    public static Explosion explodeFire(Explosion explosion) {
        explosion.field_77286_a = true;
        return EffectHelper.explode(explosion);
    }

    public static Explosion explodeSafe(Entity exploder, float power) {
        return EffectHelper.explodeSafe(EffectHelper.explosion(exploder, power));
    }

    public static Explosion explodeSafe(Explosion explosion) {
        explosion.field_82755_b = false;
        return EffectHelper.explode(explosion);
    }

    public static Explosion explodeFireSafe(Entity exploder, float power) {
        return EffectHelper.explodeFireSafe(EffectHelper.explosion(exploder, power));
    }

    public static Explosion explodeFireSafe(Explosion explosion) {
        explosion.field_77286_a = true;
        return EffectHelper.explodeSafe(explosion);
    }
}

