/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.item.IEmpowerableItem;
import cofh.core.item.IEqualityOverrideItem;
import cofh.core.util.KeyBindingEmpower;
import cofh.lib.util.helpers.DamageHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.core.RAProps;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemSwordRF
extends ItemSword
implements IEmpowerableItem,
IEnergyContainerItem,
IEqualityOverrideItem {
    IIcon activeIcon;
    IIcon drainedIcon;
    public int maxEnergy = 160000;
    public int maxTransfer = 1600;
    public int energyPerUse = 200;
    public int energyPerUseCharged = 800;
    public int damage = 8;
    public int damageCharged = 4;

    public ItemSwordRF(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.setNoRepair();
    }

    public ItemSwordRF setEnergyParams(int n, int n2, int n3, int n4) {
        this.maxEnergy = n;
        this.maxTransfer = n2;
        this.energyPerUse = n3;
        this.energyPerUseCharged = n4;
        return this;
    }

    protected int useEnergy(ItemStack itemStack, boolean bl) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return this.extractEnergy(itemStack, this.isEmpowered(itemStack) ? this.energyPerUseCharged * (5 - n) / 5 : this.energyPerUse * (5 - n) / 5, bl);
    }

    protected int getEnergyPerUse(ItemStack itemStack) {
        int n = MathHelper.clampI((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return (this.isEmpowered(itemStack) ? this.energyPerUseCharged : this.energyPerUse) * (5 - n) / 5;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        entityPlayer.func_71008_a(itemStack, this.func_77626_a(itemStack));
        return itemStack;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase entityLivingBase, EntityLivingBase entityLivingBase2) {
        if (itemStack.func_77960_j() > 0) {
            itemStack.func_77964_b(0);
        }
        EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase2;
        float f = entityLivingBase2.field_70143_R > 0.0f && !entityLivingBase2.field_70122_E && !entityLivingBase2.func_70617_f_() && !entityLivingBase2.func_70090_H() && !entityLivingBase2.func_70644_a(Potion.field_76440_q) && entityLivingBase2.field_70154_o == null ? 1.5f : 1.0f;
        float f2 = 1.0f;
        if (entityLivingBase2.func_70644_a(Potion.field_76420_g)) {
            f2 += (float)entityLivingBase2.func_70660_b(Potion.field_76420_g).func_76458_c() * 1.3f;
        }
        if (entityPlayer.field_71075_bZ.field_75098_d || this.useEnergy(itemStack, false) == this.getEnergyPerUse(itemStack)) {
            float f3 = this.isEmpowered(itemStack) ? (float)this.damageCharged : 1.0f;
            float f4 = (float)this.damage + EnchantmentHelper.func_77512_a((EntityLivingBase)entityLivingBase2, (EntityLivingBase)entityLivingBase);
            entityLivingBase.func_70097_a(DamageHelper.causePlayerFluxDamage((EntityPlayer)entityPlayer), f3 * f2);
            entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entityPlayer), (f3 + f4) * f * f2);
        } else {
            entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entityPlayer), 1.0f * f * f2);
        }
        return true;
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int n, int n2, int n3, EntityLivingBase entityLivingBase) {
        if ((double)block.func_149712_f(world, n, n2, n3) != 0.0) {
            this.extractEnergy(itemStack, this.energyPerUse, false);
        }
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl) {
        if (!this.isEmpowered(itemStack) || !bl) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70632_aY()) {
            AxisAlignedBB axisAlignedBB = entity.field_70121_D.func_72314_b(2.0, 1.0, 2.0);
            List list = entity.field_70170_p.func_72872_a(EntityMob.class, axisAlignedBB);
            for (Entity entity2 : list) {
                this.pushEntityAway(entity2, entity);
            }
        }
    }

    protected void pushEntityAway(Entity entity, Entity entity2) {
        double d = entity2.field_70165_t - entity.field_70165_t;
        double d2 = entity2.field_70161_v - entity.field_70161_v;
        double d3 = MathHelper.maxAbs((double)d, (double)d2);
        if (d3 >= 0.01) {
            d3 = Math.sqrt(d3);
            d /= d3;
            d2 /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d *= d4;
            d2 *= d4;
            d *= 0.2;
            d2 *= 0.2;
            entity.func_70024_g(-(d *= (double)(1.0f - entity.field_70144_Y)), 0.0, -(d2 *= (double)(1.0f - entity.field_70144_Y)));
        }
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + itemStack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(itemStack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        if (this.isEmpowered(itemStack)) {
            list.add("\u00a7e\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOff") + "\u00a7r");
        } else {
            list.add("\u00a7b\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.chargeOn") + "\u00a7r");
        }
        if (this.getEnergyStored(itemStack) >= this.getEnergyPerUse(itemStack)) {
            list.add("");
            list.add("\u00a79+" + this.damage + " " + StringHelper.localize((String)"info.cofh.damageAttack") + "\u00a7r");
            list.add("\u00a7a+" + (this.isEmpowered(itemStack) ? this.damageCharged : 1) + " " + StringHelper.localize((String)"info.cofh.damageFlux") + "\u00a7r");
        }
    }

    public void setDamage(ItemStack itemStack, int n) {
        super.setDamage(itemStack, 0);
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return this.maxEnergy - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return !RAProps.showToolCharge ? false : itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74767_n("CreativeTab");
    }

    public boolean isDamaged(ItemStack itemStack) {
        return true;
    }

    public Multimap func_111205_h() {
        return HashMultimap.create();
    }

    public IIcon func_77650_f(ItemStack itemStack) {
        return this.getIcon(itemStack, 0);
    }

    public IIcon getIcon(ItemStack itemStack, int n) {
        return this.isEmpowered(itemStack) ? this.activeIcon : (this.getEnergyStored(itemStack) <= 0 ? this.drainedIcon : ((Item)this).field_77791_bV);
    }

    public void func_94581_a(IIconRegister iIconRegister) {
        ((Item)this).field_77791_bV = iIconRegister.func_94245_a(this.func_111208_A());
        this.activeIcon = iIconRegister.func_94245_a(this.func_111208_A() + "_Active");
        this.drainedIcon = iIconRegister.func_94245_a(this.func_111208_A() + "_Drained");
    }

    public boolean isEmpowered(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74767_n("Empowered");
    }

    public boolean setEmpoweredState(ItemStack itemStack, boolean bl) {
        if (this.getEnergyStored(itemStack) > 0) {
            itemStack.field_77990_d.func_74757_a("Empowered", bl);
            return true;
        }
        itemStack.field_77990_d.func_74757_a("Empowered", false);
        return false;
    }

    public void onStateChange(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (this.isEmpowered(itemStack)) {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "ambient.weather.thunder", 0.4f, 1.0f);
        } else {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.6f);
        }
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(this.maxEnergy - n2, this.maxTransfer));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 += n3);
        }
        return n3;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        if (itemStack.field_77990_d.func_74764_b("Unbreakable")) {
            itemStack.field_77990_d.func_82580_o("Unbreakable");
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, n2);
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
            if (n2 == 0) {
                this.setEmpoweredState(itemStack, false);
            }
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean isLastHeldItemEqual(ItemStack itemStack, ItemStack itemStack2) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = itemStack2.field_77990_d;
        if (nBTTagCompound == nBTTagCompound2) {
            return true;
        }
        if (nBTTagCompound == null || nBTTagCompound2 == null) {
            return false;
        }
        nBTTagCompound = (NBTTagCompound)nBTTagCompound.func_74737_b();
        nBTTagCompound2 = (NBTTagCompound)nBTTagCompound2.func_74737_b();
        nBTTagCompound.func_82580_o("Energy");
        nBTTagCompound2.func_82580_o("Energy");
        return nBTTagCompound.equals((Object)nBTTagCompound2);
    }
}

