/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.plugins.nei;

import codechicken.nei.ItemPanel;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.facades.CoverHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeHandlerCover
extends ShapelessRecipeHandler {
    public static RecipeHandlerCover instance = new RecipeHandlerCover();

    public void loadCraftingRecipes(ItemStack itemStack) {
        if (itemStack.func_77973_b() != ThermalDynamics.itemCover) {
            return;
        }
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null || !nBTTagCompound.func_150297_b("Meta", 1) || !nBTTagCompound.func_150297_b("Block", 8)) {
            return;
        }
        byte by = nBTTagCompound.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nBTTagCompound.func_74779_i("Block"));
        if (block == Blocks.field_150350_a || by < 0 || by >= 16 || !CoverHelper.isValid(block, by)) {
            return;
        }
        ((TemplateRecipeHandler)this).arecipes.add(new CachedCoverRecipeSimple(new ItemStack(block, 1, (int)by)));
    }

    public void loadCraftingRecipes(String string, Object ... objectArray) {
        if (string.equals("crafting")) {
            ((TemplateRecipeHandler)this).arecipes.add(new CachedCoverRecipeAll());
        } else {
            super.loadCraftingRecipes(string, objectArray);
        }
    }

    public void loadUsageRecipes(ItemStack itemStack) {
        if (CoverHelper.isValid(itemStack)) {
            ((TemplateRecipeHandler)this).arecipes.add(new CachedCoverRecipeSimple(itemStack));
        } else if (ItemHelper.itemsEqualForCrafting((ItemStack)TDDucts.structure.itemStack, (ItemStack)itemStack)) {
            ((TemplateRecipeHandler)this).arecipes.add(new CachedCoverRecipeAll());
        }
    }

    public String getRecipeName() {
        return StringHelper.localize((String)"recipe.thermaldynamics.covers");
    }

    public boolean isRecipe2x2(int n) {
        return true;
    }

    public class CachedCoverRecipeAll
    extends ShapelessRecipeHandler.CachedShapelessRecipe {
        public CachedCoverRecipeAll() {
            super((ShapelessRecipeHandler)RecipeHandlerCover.this);
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ItemPanel.items) {
                if (!CoverHelper.isValid(itemStack)) continue;
                arrayList.add(itemStack);
            }
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(arrayList);
            arrayList2.add(TDDucts.structure.itemStack);
            this.setIngredients(arrayList2);
        }

        public PositionedStack getResult() {
            for (PositionedStack positionedStack : this.ingredients) {
                ItemStack itemStack = positionedStack.item;
                if (itemStack == TDDucts.structure.itemStack || !CoverHelper.isValid(itemStack)) continue;
                this.setResult(ItemHelper.cloneStack((ItemStack)CoverHelper.getCoverStack(itemStack), (int)6));
                return super.getResult();
            }
            return null;
        }
    }

    public class CachedCoverRecipeSimple
    extends ShapelessRecipeHandler.CachedShapelessRecipe {
        public CachedCoverRecipeSimple(ItemStack itemStack) {
            super((ShapelessRecipeHandler)RecipeHandlerCover.this, new Object[]{itemStack, TDDucts.structure.itemStack}, ItemHelper.cloneStack((ItemStack)CoverHelper.getCoverStack(itemStack), (int)6));
        }
    }
}

