/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.data.ISided;
import com.carpentersblocks.tileentity.TEBase;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Torch
implements ISided {
    public static final byte TYPE_VANILLA = 0;
    public static final byte TYPE_LANTERN = 1;

    @Override
    public ForgeDirection getDirection(TEBase TE) {
        return ForgeDirection.getOrientation((int)(TE.getData() & 7));
    }

    @Override
    public void setDirection(TEBase TE, ForgeDirection dir) {
        int temp = TE.getData() & 0xFFFFFFF8 | dir.ordinal();
        TE.setData(temp);
    }

    public int getType(TEBase TE) {
        return (TE.getData() & 0x1E0) >> 5;
    }

    public void setType(TEBase TE, int type) {
        int temp = TE.getData() & 0xFFFFFE1F | (type & 0xF) << 5;
        TE.setData(temp);
    }

    public State getState(TEBase TE) {
        int temp = (TE.getData() & 0x18) >> 3;
        return temp == State.LIT.ordinal() ? State.LIT : (temp == State.SMOLDERING.ordinal() ? State.SMOLDERING : State.UNLIT);
    }

    public void setState(TEBase TE, State state) {
        if (state.ordinal() > this.getState(TE).ordinal()) {
            double[] headCoords = this.getHeadCoordinates(TE);
            World world = TE.func_145831_w();
            world.func_72908_a(headCoords[0], headCoords[1], headCoords[2], "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        }
        int temp = TE.getData() & 0xFFFFFFE7 | state.ordinal() << 3;
        TE.setData(temp);
    }

    public double[] getHeadCoordinates(TEBase TE) {
        double[] coords;
        double xOffset = (float)TE.field_145851_c + 0.5f;
        double yOffset = (float)TE.field_145848_d + 0.7f;
        double zOffset = (float)TE.field_145849_e + 0.5f;
        if (this.getType(TE) == 0) {
            double offset1 = 0.22f;
            double offset2 = 0.27f;
            ForgeDirection side = this.getDirection(TE);
            switch (side) {
                case NORTH: {
                    coords = new double[]{xOffset, yOffset + offset1, zOffset + offset2};
                    break;
                }
                case SOUTH: {
                    coords = new double[]{xOffset, yOffset + offset1, zOffset - offset2};
                    break;
                }
                case WEST: {
                    coords = new double[]{xOffset + offset2, yOffset + offset1, zOffset};
                    break;
                }
                case EAST: {
                    coords = new double[]{xOffset - offset2, yOffset + offset1, zOffset};
                    break;
                }
                default: {
                    coords = new double[]{xOffset, yOffset, zOffset};
                    break;
                }
            }
        } else {
            coords = new double[]{xOffset, (float)TE.field_145848_d + 0.5625f, zOffset};
        }
        return coords;
    }

    public static enum State {
        LIT,
        SMOLDERING,
        UNLIT;

    }
}

