/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.EntityLivingUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Safe {
    public static final byte STATE_CLOSED = 0;
    public static final byte STATE_OPEN = 1;
    public static final byte LOCK_SET = 0;
    public static final byte LOCK_UNSET = 1;
    public static final byte AUTOMATION_DISABLED = 0;
    public static final byte AUTOMATION_SEND = 1;
    public static final byte AUTOMATION_RECEIVE = 2;
    public static final byte AUTOMATION_ALL = 3;

    public static ForgeDirection getFacing(TEBase TE) {
        return EntityLivingUtil.getRotationFacing(TE.getData() & 3).getOpposite();
    }

    public static void setFacing(TEBase TE, int facing) {
        int temp = TE.getData() & 0xFFFFFFFC | facing;
        TE.setData(temp);
    }

    public static int getState(TEBase TE) {
        return (TE.getData() & 4) >> 2;
    }

    public static void setState(TEBase TE, int state) {
        int temp = TE.getData() & 0xFFFFFFFB | state << 2;
        World world = TE.func_145831_w();
        if (!world.field_72995_K) {
            world.func_72889_a((EntityPlayer)null, 1003, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, 0);
        }
        TE.setData(temp);
    }

    public static boolean isLocked(TEBase TE) {
        return (TE.getData() & 8) == 0;
    }

    public static void setLocked(TEBase TE, boolean isLocked) {
        int temp = TE.getData() & 0xFFFFFFF7 | (isLocked ? 0 : 1) << 3;
        TE.setData(temp);
    }

    public static int getAutoPerm(TEBase TE) {
        return (TE.getData() & 0x30) >> 4;
    }

    public static void setAutoPerm(TEBase TE, int autoPerm) {
        int temp = TE.getData() & 0xFFFFFFCF | autoPerm << 4;
        TE.setData(temp);
    }

    public static boolean isOpen(TEBase TE) {
        return Safe.getState(TE) == 1;
    }

    public static boolean allowsInsertion(TEBase TE) {
        int autoPerm = Safe.getAutoPerm(TE);
        return autoPerm == 2 || autoPerm == 3;
    }

    public static boolean allowsExtraction(TEBase TE) {
        int autoPerm = Safe.getAutoPerm(TE);
        return autoPerm == 1 || autoPerm == 3;
    }
}

