/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.ISided;
import com.carpentersblocks.tileentity.TEBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSided
extends BlockCoverable {
    private ISided data = null;

    public BlockSided(Material material, ISided data) {
        super(material);
        this.data = data;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (this.canAttachToSide(side)) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            return world.func_147439_a(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ).isSideSolid((IBlockAccess)world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir);
        }
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int meta = world.func_72805_g(x, y, z);
            this.data.setDirection(TE, ForgeDirection.getOrientation((int)meta));
        }
    }

    public void func_149714_e(World world, int x, int y, int z, int metadata) {
        world.func_147459_d(x, y, z, (Block)this);
    }

    public int func_149738_a(World world) {
        return 20;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TEBase TE;
        super.func_149695_a(world, x, y, z, block);
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && !this.func_149707_d(world, x, y, z, this.data.getDirection(TE).ordinal())) {
            this.destroyBlock(world, x, y, z, true);
        }
    }

    public void notifyBlocksOfPowerChange(World world, int x, int y, int z) {
        world.func_147444_c(x, y, z, (Block)this);
        if (this.func_149744_f()) {
            TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
            if (TE != null) {
                ForgeDirection dir = this.data.getDirection(TE);
                world.func_147459_d(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, (Block)this);
            } else {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    world.func_147459_d(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, (Block)this);
                }
            }
        }
    }

    @Override
    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int tempPower;
        TEBase TE;
        int power = super.func_149709_b(blockAccess, x, y, z, side);
        if (this.func_149744_f() && (TE = this.getTileEntity(blockAccess, x, y, z)) != null && (tempPower = this.getPowerOutput(TE)) > power) {
            power = tempPower;
        }
        return power;
    }

    @Override
    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int tempPower;
        TEBase TE;
        int power = super.func_149748_c(blockAccess, x, y, z, side);
        if (this.func_149744_f() && (TE = this.getTileEntity(blockAccess, x, y, z)) != null && side == this.data.getDirection(TE).ordinal() && (tempPower = this.getPowerOutput(TE)) > power) {
            power = tempPower;
        }
        return power;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        if (this.func_149744_f()) {
            this.notifyBlocksOfPowerChange(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public int getPowerOutput(TEBase TE) {
        return 0;
    }

    public boolean canAttachToSide(int side) {
        return true;
    }
}

