/*
 * Decompiled with CFR 0.152.
 */
package net.spanser.furnace3d.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.spanser.furnace3d.Furnace3D;
import net.spanser.furnace3d.handlers.network.AbstractPacket;
import net.spanser.furnace3d.handlers.network.DataBlockPacket;

public abstract class NetworkTileEntity
extends TileEntity {
    public boolean shouldSendInitData = true;
    public EntityPlayer entityplayer;
    protected int broadcastRange = 256;

    public abstract void handleInitPacket(NBTTagCompound var1);

    public void handleDataPacket(NBTTagCompound nbt) {
    }

    public void createDataNBT(NBTTagCompound nbt) {
    }

    public abstract void createInitNBT(NBTTagCompound var1);

    public DataBlockPacket createDataPacket() {
        return this.createDataPacket(this.createDataNBT());
    }

    public DataBlockPacket createDataPacket(NBTTagCompound nbt) {
        return new DataBlockPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, nbt);
    }

    private NBTTagCompound createDataNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.createDataNBT(nbt);
        return nbt;
    }

    private NBTTagCompound createInitNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.createInitNBT(nbt);
        return nbt;
    }

    public Packet func_145844_m() {
        if (this.shouldSendInitData) {
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, this.createInitNBT());
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.handleInitPacket(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void broadcastPacketInRange() {
        int dim = this.field_145850_b.field_73011_w.field_76574_g;
        if (this.field_145850_b.field_72995_K) {
            Furnace3D.packetPipeline.sendToServer(this.createDataPacket());
        } else {
            Furnace3D.packetPipeline.sendToAllAround(this.createDataPacket(), new NetworkRegistry.TargetPoint(dim, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.broadcastRange));
        }
    }

    public void broadcastPacketInRange(AbstractPacket packet) {
        if (this.field_145850_b.field_72995_K) {
            Furnace3D.packetPipeline.sendToServer(packet);
        } else {
            Furnace3D.packetPipeline.sendToAllAround(packet, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.broadcastRange));
        }
    }
}

