/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.VacuumFreezer")
@ModOnly(value={"gregtech"})
public class VacuumFreezer {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int durationTicks) {
        MineTweakerAPI.apply(new AddRecipeAction(output, input, durationTicks));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final IItemStack input;
        private final int duration;

        public AddRecipeAction(IItemStack output, IItemStack input, int duration) {
            this.output = output;
            this.input = input;
            this.duration = duration;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addVacuumFreezerRecipe(MineTweakerMC.getItemStack(this.input), MineTweakerMC.getItemStack(this.output), this.duration);
        }

        @Override
        public String describe() {
            return "Adding vacuum freezer recipe for " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 67 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 67 * hash + this.duration;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)obj;
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            return this.duration == other.duration;
        }
    }
}

