/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import java.util.Arrays;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.DistillationTower")
@ModOnly(value={"gregtech"})
public class DistillationTower {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int cells, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply(new AddRecipeAction(new IItemStack[]{output}, input, cells, durationTicks, euPerTick));
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IItemStack input, int cells, int durationTicks, int euPerTick) {
        if (outputs.length == 0) {
            MineTweakerAPI.logError("Distillation tower recipe requires at least 1 output");
        } else {
            MineTweakerAPI.apply(new AddRecipeAction(outputs, input, cells, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack[] outputs;
        private final IItemStack input;
        private final int cells;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack[] outputs, IItemStack input, int cells, int duration, int euPerTick) {
            this.outputs = outputs;
            this.input = input;
            this.cells = cells;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addDistillationRecipe(MineTweakerMC.getItemStack(this.input), this.cells, MineTweakerMC.getItemStack(this.outputs[0]), this.outputs.length > 1 ? MineTweakerMC.getItemStack(this.outputs[1]) : null, this.outputs.length > 2 ? MineTweakerMC.getItemStack(this.outputs[2]) : null, this.outputs.length > 3 ? MineTweakerMC.getItemStack(this.outputs[3]) : null, this.duration, this.euPerTick);
        }

        @Override
        public String describe() {
            return "Adding Distillation tower recipe for " + this.outputs[0];
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + Arrays.deepHashCode(this.outputs);
            hash = 41 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 41 * hash + this.cells;
            hash = 41 * hash + this.duration;
            hash = 41 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)obj;
            if (!Arrays.deepEquals(this.outputs, other.outputs)) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.cells != other.cells) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

