/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Boxing")
@ModOnly(value={"gregtech"})
public class Boxing {
    @ZenMethod
    public static void addBoxingRecipe(IItemStack fullBox, IItemStack item, IItemStack emptyBox, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply(new AddBoxingAction(fullBox, item, emptyBox, durationTicks, euPerTick));
    }

    @ZenMethod
    public static void addUnboxingRecipe(IItemStack item, IItemStack emptyBox, IItemStack fullBox, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply(new AddUnboxingAction(item, emptyBox, fullBox, durationTicks, euPerTick));
    }

    private static class AddUnboxingAction
    extends OneWayAction {
        private final IItemStack item;
        private final IItemStack emptyBox;
        private final IItemStack fullBox;
        private final int duration;
        private final int euPerTick;

        public AddUnboxingAction(IItemStack item, IItemStack emptyBox, IItemStack fullBox, int duration, int euPerTick) {
            this.item = item;
            this.emptyBox = emptyBox;
            this.fullBox = fullBox;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addUnboxingRecipe(MineTweakerMC.getItemStack(this.fullBox), MineTweakerMC.getItemStack(this.item), MineTweakerMC.getItemStack(this.emptyBox), this.duration, this.euPerTick);
        }

        @Override
        public String describe() {
            return "Adding unboxing recipe to unbox " + this.fullBox;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 3;
            hash = 83 * hash + (this.item != null ? this.item.hashCode() : 0);
            hash = 83 * hash + (this.emptyBox != null ? this.emptyBox.hashCode() : 0);
            hash = 83 * hash + (this.fullBox != null ? this.fullBox.hashCode() : 0);
            hash = 83 * hash + this.duration;
            hash = 83 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddUnboxingAction other = (AddUnboxingAction)obj;
            if (!(this.item == other.item || this.item != null && this.item.equals(other.item))) {
                return false;
            }
            if (!(this.emptyBox == other.emptyBox || this.emptyBox != null && this.emptyBox.equals(other.emptyBox))) {
                return false;
            }
            if (!(this.fullBox == other.fullBox || this.fullBox != null && this.fullBox.equals(other.fullBox))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }

    private static class AddBoxingAction
    extends OneWayAction {
        private final IItemStack fullBox;
        private final IItemStack item;
        private final IItemStack emptyBox;
        private final int duration;
        private final int euPerTick;

        public AddBoxingAction(IItemStack fullBox, IItemStack item, IItemStack emptyBox, int duration, int euPerTick) {
            this.fullBox = fullBox;
            this.item = item;
            this.emptyBox = emptyBox;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addBoxingRecipe(MineTweakerMC.getItemStack(this.item), MineTweakerMC.getItemStack(this.emptyBox), MineTweakerMC.getItemStack(this.fullBox), this.duration, this.euPerTick);
        }

        @Override
        public String describe() {
            return "Adding boxing recipe to pack " + this.item + " in " + this.emptyBox;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + (this.fullBox != null ? this.fullBox.hashCode() : 0);
            hash = 89 * hash + (this.item != null ? this.item.hashCode() : 0);
            hash = 89 * hash + (this.emptyBox != null ? this.emptyBox.hashCode() : 0);
            hash = 89 * hash + this.duration;
            hash = 89 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddBoxingAction other = (AddBoxingAction)obj;
            if (!(this.fullBox == other.fullBox || this.fullBox != null && this.fullBox.equals(other.fullBox))) {
                return false;
            }
            if (!(this.item == other.item || this.item != null && this.item.equals(other.item))) {
                return false;
            }
            if (!(this.emptyBox == other.emptyBox || this.emptyBox != null && this.emptyBox.equals(other.emptyBox))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

