/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.gregtech.machines;

import gregtech.api.GregTech_API;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Amplifabricator")
@ModOnly(value={"gregtech"})
public class Amplifabricator {
    @ZenMethod
    public static void addAmplifier(IItemStack item, int durationTicks, int amount) {
        MineTweakerAPI.apply(new AddAmplifierAction(item, durationTicks, amount));
    }

    private static class AddAmplifierAction
    extends OneWayAction {
        private final IItemStack item;
        private final int duration;
        private final int amount;

        public AddAmplifierAction(IItemStack item, int duration, int amount) {
            this.item = item;
            this.duration = duration;
            this.amount = amount;
        }

        @Override
        public void apply() {
            GregTech_API.sRecipeAdder.addAmplifier(MineTweakerMC.getItemStack(this.item), this.duration, this.amount);
        }

        @Override
        public String describe() {
            return "Adding amplifier " + this.item;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + (this.item != null ? this.item.hashCode() : 0);
            hash = 59 * hash + this.duration;
            hash = 59 * hash + this.amount;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddAmplifierAction other = (AddAmplifierAction)obj;
            if (!(this.item == other.item || this.item != null && this.item.equals(other.item))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.amount == other.amount;
        }
    }
}

