/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.WeightedRandomNBTTag;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;

public class WorldGenDungeon
extends WorldGenerator {
    private final List<WeightedRandomBlock> walls;
    private final WeightedRandomBlock[] genBlock;
    private final WeightedRandomNBTTag[] spawners;
    public int minWidthX = 2;
    public int maxWidthX = 3;
    public int minWidthZ = 2;
    public int maxWidthZ = 3;
    public int minHeight = 3;
    public int maxHeight = 3;
    public int minHoles = 1;
    public int maxHoles = 5;
    public int maxChests = 2;
    public List<DungeonHooks.DungeonMob> lootTables = Arrays.asList(new DungeonHooks.DungeonMob(100, "dungeonChest"));
    public List<WeightedRandomBlock> floor;

    public WorldGenDungeon(List<WeightedRandomBlock> list, List<WeightedRandomBlock> list2, List<WeightedRandomNBTTag> list3) {
        this.walls = list;
        this.floor = this.walls;
        this.spawners = list3.toArray(new WeightedRandomNBTTag[list3.size()]);
        this.genBlock = list2.toArray(new WeightedRandomBlock[list2.size()]);
    }

    public boolean func_76484_a(World world, Random random, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n2 <= 2) {
            return false;
        }
        int n7 = WorldGenDungeon.nextInt(random, this.maxHeight - this.minHeight + 1) + this.minHeight;
        int n8 = WorldGenDungeon.nextInt(random, this.maxWidthX - this.minWidthX + 1) + this.minWidthX;
        int n9 = WorldGenDungeon.nextInt(random, this.maxWidthZ - this.minWidthZ + 1) + this.minWidthZ;
        int n10 = 0;
        int n11 = n2 - 1;
        int n12 = n2 + n7 + 1;
        for (n6 = n - n8 - 1; n6 <= n + n8 + 1; ++n6) {
            for (n5 = n3 - n9 - 1; n5 <= n3 + n9 + 1; ++n5) {
                for (n4 = n11; n4 <= n12; ++n4) {
                    if (n4 == n11 && !WorldGenMinableCluster.canGenerateInBlock(world, n6, n4, n5, this.genBlock)) {
                        return false;
                    }
                    if (n4 == n12 && !WorldGenMinableCluster.canGenerateInBlock(world, n6, n4, n5, this.genBlock)) {
                        return false;
                    }
                    if (Math.abs(n6 - n) != n8 + 1 && Math.abs(n5 - n3) != n9 + 1 || n4 != n2 || !world.func_147437_c(n6, n4, n5) || !world.func_147437_c(n6, n4 + 1, n5)) continue;
                    ++n10;
                }
            }
        }
        if (n10 < this.minHoles || n10 > this.maxHoles) {
            return false;
        }
        NBTTagCompound nBTTagCompound = (NBTTagCompound)((WeightedRandomNBTTag)WeightedRandom.func_76274_a((Random)random, (WeightedRandom.Item[])this.spawners)).tag;
        ChestGenHooks chestGenHooks = ChestGenHooks.getInfo((String)((DungeonHooks.DungeonMob)WeightedRandom.func_76271_a((Random)random, this.lootTables)).type);
        for (n6 = n - n8 - 1; n6 <= n + n8 + 1; ++n6) {
            for (n5 = n3 - n9 - 1; n5 <= n3 + n9 + 1; ++n5) {
                for (n4 = n2 + n7; n4 >= n11; --n4) {
                    if ((Math.abs(n6 - n) != n8 + 1 || Math.abs(n5 - n3) != n9 + 1) && n4 != n12) {
                        world.func_147468_f(n6, n4, n5);
                        continue;
                    }
                    if (n4 >= 0 && !WorldGenMinableCluster.canGenerateInBlock(world, n6, n4 - 1, n5, this.genBlock)) {
                        world.func_147468_f(n6, n4, n5);
                        continue;
                    }
                    if (!WorldGenMinableCluster.canGenerateInBlock(world, n6, n4, n5, this.genBlock)) continue;
                    if (n4 == n11) {
                        WorldGenMinableCluster.generateBlock(world, n6, n4, n5, this.floor);
                        continue;
                    }
                    WorldGenMinableCluster.generateBlock(world, n6, n4, n5, this.walls);
                }
            }
        }
        int n13 = this.maxChests;
        block6: while (n13-- > 0) {
            for (int i = 0; i < 3; ++i) {
                n6 = n + WorldGenDungeon.nextInt(random, n8 * 2 + 1) - n8;
                if (!world.func_147437_c(n6, n2, n5 = n3 + WorldGenDungeon.nextInt(random, n9 * 2 + 1) - n9)) continue;
                int n14 = 0;
                if (this.isWall(world, n6 - 1, n2, n5)) {
                    ++n14;
                }
                if (this.isWall(world, n6 + 1, n2, n5)) {
                    ++n14;
                }
                if (this.isWall(world, n6, n2, n5 - 1)) {
                    ++n14;
                }
                if (this.isWall(world, n6, n2, n5 + 1)) {
                    ++n14;
                }
                if (n14 < 1 || n14 > 2) continue;
                world.func_147465_d(n6, n2, n5, (Block)Blocks.field_150486_ae, 0, 2);
                TileEntityChest tileEntityChest = (TileEntityChest)world.func_147438_o(n6, n2, n5);
                if (tileEntityChest == null) continue block6;
                WeightedRandomChestContent.func_76293_a((Random)random, (WeightedRandomChestContent[])chestGenHooks.getItems(random), (IInventory)tileEntityChest, (int)chestGenHooks.getCount(random));
                continue block6;
            }
        }
        world.func_147465_d(n, n2, n3, Blocks.field_150474_ac, 0, 2);
        TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)world.func_147438_o(n, n2, n3);
        if (tileEntityMobSpawner != null) {
            tileEntityMobSpawner.func_145881_a().func_98270_a(nBTTagCompound);
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + n + ", " + n2 + ", " + n3 + ")");
        }
        return true;
    }

    private static int nextInt(Random random, int n) {
        if (n <= 1) {
            return 0;
        }
        return random.nextInt(n);
    }

    private boolean isWall(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        return WeightedRandomBlock.isBlockContained(world.func_147439_a(n, n2, n3), n4, this.walls);
    }
}

