/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.util.Random;

public final class MathHelper {
    public static final Random RANDOM = new Random();
    public static final double PHI = 1.618034;
    public static final double[] SIN_TABLE = new double[65536];

    private MathHelper() {
    }

    public static double sin(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f) & 0xFFFF];
    }

    public static double cos(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static int clampI(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static float clampF(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static float approachLinear(float f, float f2, float f3) {
        return f > f2 ? (f - f2 < f3 ? f2 : f - f3) : (f2 - f < f3 ? f2 : f + f3);
    }

    public static double approachLinear(double d, double d2, double d3) {
        return d > d2 ? (d - d2 < d3 ? d2 : d - d3) : (d2 - d < d3 ? d2 : d + d3);
    }

    public static float interpolate(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static double interpolate(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    public static double approachExp(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    public static double approachExp(double d, double d2, double d3, double d4) {
        double d5 = (d2 - d) * d3;
        if (Math.abs(d5) > d4) {
            d5 = Math.signum(d5) * d4;
        }
        return d + d5;
    }

    public static double retreatExp(double d, double d2, double d3, double d4, double d5) {
        double d6 = (Math.abs(d3 - d) + d5) * d4;
        if (d6 > Math.abs(d2 - d)) {
            return d2;
        }
        return d + Math.signum(d2 - d) * d6;
    }

    public static double clip(double d, double d2, double d3) {
        if (d > d3) {
            d = d3;
        } else if (d < d2) {
            d = d2;
        }
        return d;
    }

    public static boolean between(double d, double d2, double d3) {
        return d <= d2 && d2 <= d3;
    }

    public static int approachExpI(int n, int n2, double d) {
        int n3 = (int)Math.round(MathHelper.approachExp(n, n2, d));
        return n3 == n ? n2 : n3;
    }

    public static int retreatExpI(int n, int n2, int n3, double d, int n4) {
        int n5 = (int)Math.round(MathHelper.retreatExp(n, n2, n3, d, n4));
        return n5 == n ? n2 : n5;
    }

    public static int round(double d) {
        return (int)(d + 0.5);
    }

    public static int ceil(double d) {
        return (int)(d + 0.9999);
    }

    public static int floor(double d) {
        int n = (int)d;
        return d < (double)n ? n - 1 : n;
    }

    public static float minF(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static float minF(int n, float f) {
        return (float)n < f ? (float)n : f;
    }

    public static float minF(float f, int n) {
        return f < (float)n ? f : (float)n;
    }

    public static float maxF(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static float maxF(int n, float f) {
        return (float)n > f ? (float)n : f;
    }

    public static float maxF(float f, int n) {
        return f > (float)n ? f : (float)n;
    }

    public static double maxAbs(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        return d > d2 ? d : d2;
    }

    public static int setBit(int n, int n2, boolean bl) {
        return n |= (bl ? 1 : 0) << n2;
    }

    public static boolean isBitSet(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = Math.sin((double)i / 65536.0 * 2.0 * Math.PI);
        }
        MathHelper.SIN_TABLE[0] = 0.0;
        MathHelper.SIN_TABLE[16384] = 1.0;
        MathHelper.SIN_TABLE[32768] = 0.0;
        MathHelper.SIN_TABLE[49152] = 1.0;
    }
}

