/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.CoFHCore;
import cofh.api.tileentity.IEnergyInfo;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class TabEnergy
extends TabBase {
    public static boolean enable;
    public static int defaultSide;
    public static int defaultHeaderColor;
    public static int defaultSubHeaderColor;
    public static int defaultTextColor;
    public static int defaultBackgroundColorOut;
    public static int defaultBackgroundColorIn;
    IEnergyInfo myContainer;
    boolean isProducer;

    public static void initialize() {
        String string = "Tab.Energy";
        defaultSide = MathHelper.clampI(CoFHCore.configClient.get(string, "Side", defaultSide), 0, 1);
        defaultHeaderColor = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorHeader", defaultHeaderColor), 0, 0xFFFFFF);
        defaultSubHeaderColor = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorSubHeader", defaultSubHeaderColor), 0, 0xFFFFFF);
        defaultTextColor = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorText", defaultTextColor), 0, 0xFFFFFF);
        defaultBackgroundColorOut = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorBackgroundProducer", defaultBackgroundColorOut), 0, 0xFFFFFF);
        defaultBackgroundColorIn = MathHelper.clampI(CoFHCore.configClient.get(string, "ColorBackgroundConsumer", defaultBackgroundColorIn), 0, 0xFFFFFF);
        CoFHCore.configClient.save();
    }

    public TabEnergy(GuiBase guiBase, IEnergyInfo iEnergyInfo, boolean bl) {
        this(guiBase, defaultSide, iEnergyInfo, bl);
    }

    public TabEnergy(GuiBase guiBase, int n, IEnergyInfo iEnergyInfo, boolean bl) {
        super(guiBase, n);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = bl ? defaultBackgroundColorOut : defaultBackgroundColorIn;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myContainer = iEnergyInfo;
        this.isProducer = bl;
    }

    @Override
    public void draw() {
        this.drawBackground();
        this.drawTabIcon("IconEnergy");
        if (!this.isFullyOpened()) {
            return;
        }
        String string = this.isProducer ? "info.cofh.energyProduce" : "info.cofh.energyConsume";
        this.getFontRenderer().func_78261_a(StringHelper.localize("info.cofh.energy"), this.posXOffset() + 20, this.posY + 6, this.headerColor);
        this.getFontRenderer().func_78261_a(StringHelper.localize(string) + ":", this.posXOffset() + 6, this.posY + 18, this.subheaderColor);
        this.getFontRenderer().func_78276_b(this.myContainer.getInfoEnergyPerTick() + " RF/t", this.posXOffset() + 14, this.posY + 30, this.textColor);
        this.getFontRenderer().func_78261_a(StringHelper.localize("info.cofh.maxEnergyPerTick") + ":", this.posXOffset() + 6, this.posY + 42, this.subheaderColor);
        this.getFontRenderer().func_78276_b(this.myContainer.getInfoMaxEnergyPerTick() + " RF/t", this.posXOffset() + 14, this.posY + 54, this.textColor);
        this.getFontRenderer().func_78261_a(StringHelper.localize("info.cofh.energyStored") + ":", this.posXOffset() + 6, this.posY + 66, this.subheaderColor);
        this.getFontRenderer().func_78276_b(this.myContainer.getInfoEnergyStored() + " RF", this.posXOffset() + 14, this.posY + 78, this.textColor);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.myContainer.getInfoEnergyPerTick() + " RF/t");
            return;
        }
    }

    static {
        defaultSide = 0;
        defaultHeaderColor = 14797103;
        defaultSubHeaderColor = 11186104;
        defaultTextColor = 0;
        defaultBackgroundColorOut = 13657355;
        defaultBackgroundColorIn = 685776;
    }
}

