/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.registry;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.util.helpers.ItemHelper;
import erogenousbeef.bigreactors.api.IReactorFuel;
import erogenousbeef.bigreactors.api.data.FluidToReactantMapping;
import erogenousbeef.bigreactors.api.data.OreDictToReactantMapping;
import erogenousbeef.bigreactors.api.data.ReactantData;
import erogenousbeef.bigreactors.api.data.SourceProductMapping;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.data.ReactorSolidMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Reactants {
    public static final int standardSolidReactantAmount = 1000;
    public static final int standardFluidReactantAmount = 1;
    private static Map<String, ReactantData> _reactants = new HashMap<String, ReactantData>();
    private static Map<String, OreDictToReactantMapping> _solidToReactant = new HashMap<String, OreDictToReactantMapping>();
    private static Map<String, FluidToReactantMapping> _fluidToReactant = new HashMap<String, FluidToReactantMapping>();
    private static Map<String, List<SourceProductMapping>> _reactantToSolid = new HashMap<String, List<SourceProductMapping>>();
    private static Map<String, List<SourceProductMapping>> _reactantToFluid = new HashMap<String, List<SourceProductMapping>>();
    private static Map<String, ItemStack> _reactorFluidToSolid = new HashMap<String, ItemStack>();
    private static Set<ReactorSolidMapping> _reactorSolidToFuel = new CopyOnWriteArraySet<ReactorSolidMapping>();
    private static Set<ReactorSolidMapping> _reactorSolidToWaste = new CopyOnWriteArraySet<ReactorSolidMapping>();
    private static Map<String, IReactorFuel> _reactorFluids = new HashMap<String, IReactorFuel>();

    public static void registerReactant(String name, boolean fuel) {
        Reactants.registerReactant(name, fuel ? 0 : 1, fuel ? 12368464 : 5083829);
    }

    public static void registerReactant(String name, int type, int color) {
        if (type < 0 || type >= ReactantData.s_Types.length) {
            throw new IllegalArgumentException("Unsupported type; value may only be 0 or 1");
        }
        if (_reactants.containsKey(name)) {
            BRLog.warning("Overwriting data for reactant %s - someone may be altering BR game data or have duplicate reactant names!", name);
        }
        ReactantData data = new ReactantData(name, ReactantData.s_Types[type], color);
        _reactants.put(name, data);
    }

    public static SourceProductMapping registerSolid(ItemStack itemStack, String reactantName) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        ArrayList oreDictNames = OreDictionaryArbiter.getAllOreNames((ItemStack)itemStack);
        if (oreDictNames == null || oreDictNames.size() < 1) {
            BRLog.warning("Reactants.registerSolid: Could not resolve ore dict name for %s", itemStack.func_77977_a());
            return null;
        }
        OreDictToReactantMapping firstMapping = null;
        for (String name : oreDictNames) {
            OreDictToReactantMapping mapping = new OreDictToReactantMapping(name, reactantName);
            SourceProductMapping reverseMapping = mapping.getReverse();
            _solidToReactant.put(mapping.getSource(), mapping);
            Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToSolid);
            if (firstMapping != null) continue;
            firstMapping = mapping;
        }
        return firstMapping;
    }

    public static SourceProductMapping registerSolid(ItemStack itemStack, String reactantName, int reactantQty) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        ArrayList oreDictNames = OreDictionaryArbiter.getAllOreNames((ItemStack)itemStack);
        if (oreDictNames == null || oreDictNames.size() < 1) {
            BRLog.warning("Reactants.registerSolid: Could not resolve ore dict name for %s", itemStack.func_77977_a());
            return null;
        }
        OreDictToReactantMapping firstMapping = null;
        for (String name : oreDictNames) {
            OreDictToReactantMapping mapping = new OreDictToReactantMapping(name, reactantName, reactantQty);
            SourceProductMapping reverseMapping = mapping.getReverse();
            _solidToReactant.put(mapping.getSource(), mapping);
            Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToSolid);
            if (firstMapping != null) continue;
            firstMapping = mapping;
        }
        return firstMapping;
    }

    public static SourceProductMapping registerSolid(String oreDictName, String reactantName, int reactantAmount) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        OreDictToReactantMapping mapping = new OreDictToReactantMapping(oreDictName, reactantName, reactantAmount);
        _solidToReactant.put(mapping.getSource(), mapping);
        SourceProductMapping reverseMapping = mapping.getReverse();
        Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToSolid);
        return mapping;
    }

    public static SourceProductMapping registerSolid(String oreDictName, String reactantName) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        OreDictToReactantMapping mapping = new OreDictToReactantMapping(oreDictName, reactantName);
        SourceProductMapping reverseMapping = mapping.getReverse();
        _solidToReactant.put(mapping.getSource(), mapping);
        Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToSolid);
        return mapping;
    }

    public static void registerFluid(FluidStack fluidStack, String reactantName) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        FluidToReactantMapping mapping = new FluidToReactantMapping(fluidStack, reactantName);
        SourceProductMapping reverseMapping = mapping.getReverse();
        _fluidToReactant.put(mapping.getSource(), mapping);
        Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToFluid);
    }

    public static void registerFluid(Fluid fluid, String reactantName) {
        if (!_reactants.containsKey(reactantName)) {
            throw new IllegalArgumentException("Unknown reactantName " + reactantName);
        }
        FluidToReactantMapping mapping = new FluidToReactantMapping(fluid, reactantName);
        SourceProductMapping reverseMapping = mapping.getReverse();
        _fluidToReactant.put(mapping.getSource(), mapping);
        Reactants.mapReactant(reverseMapping.getSource(), reverseMapping, _reactantToFluid);
    }

    public static boolean isKnown(String reactantName) {
        return _reactants.containsKey(reactantName);
    }

    public static ReactantData getReactant(String name) {
        return _reactants.get(name);
    }

    public static OreDictToReactantMapping getSolidToReactant(ItemStack item) {
        return _solidToReactant.get(ItemHelper.oreProxy.getOreName(item));
    }

    public static FluidToReactantMapping getFluidToReactant(FluidStack fluid) {
        return _fluidToReactant.get(fluid.getFluid().getName());
    }

    public static FluidToReactantMapping getFluidToReactant(Fluid fluid) {
        return _fluidToReactant.get(fluid.getName());
    }

    public static List<SourceProductMapping> getReactantToSolids(String reactant) {
        return _reactantToSolid.get(reactant);
    }

    public static List<SourceProductMapping> getFluidsForReactant(String reactant) {
        return _reactantToFluid.get(reactant);
    }

    public static boolean isFuel(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return Reactants.isFuel(Reactants.getReactantName(stack));
    }

    public static String getReactantName(ItemStack stack) {
        OreDictToReactantMapping mapping = Reactants.getSolidToReactant(stack);
        return mapping != null ? mapping.getProduct() : null;
    }

    public static boolean isFuel(String name) {
        if (name == null) {
            return false;
        }
        ReactantData data = Reactants.getReactant(name);
        return data != null && data.isFuel();
    }

    public static boolean isWaste(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return Reactants.isWaste(Reactants.getReactantName(stack));
    }

    public static boolean isWaste(String name) {
        if (name == null) {
            return false;
        }
        ReactantData data = Reactants.getReactant(name);
        return data != null && data.isWaste();
    }

    public static int getMinimumReactantToProduceSolid(String reactantName) {
        List<SourceProductMapping> mappings = Reactants.getReactantToSolids(reactantName);
        if (mappings == null || mappings.size() <= 0) {
            throw new IllegalArgumentException("No solid products mapped for reactant " + reactantName);
        }
        int minimumAmount = Integer.MAX_VALUE;
        for (SourceProductMapping mapping : mappings) {
            if (mapping.getSourceAmount() >= minimumAmount) continue;
            minimumAmount = mapping.getSourceAmount();
        }
        return minimumAmount;
    }

    private static void mapReactant(String reactantName, SourceProductMapping mapping, Map<String, List<SourceProductMapping>> map) {
        List<Object> list = null;
        if (!map.containsKey(reactantName) || map.get(reactantName) == null) {
            list = new ArrayList();
            map.put(reactantName, list);
        } else {
            list = map.get(reactantName);
            list.add(mapping);
        }
        list.add(mapping);
    }
}

