/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.gui.client.GuiToolWorkstation;
import fi.dy.masa.enderutilities.inventory.ContainerToolWorkstation;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesSided;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityToolWorkstation
extends TileEntityEnderUtilitiesSided {
    public static final int SLOT_TOOL = 0;
    public static final int SLOT_MODULES_START = 1;
    public static final int SLOT_MODULE_STORAGE_START = 11;
    public static final int NUM_MODULE_SLOTS = 10;
    public static final int NUM_STORAGE_SLOTS = 9;
    private static final int[] SLOTS = new int[0];

    public TileEntityToolWorkstation() {
        super("toolworkstation");
        this.itemStacks = new ItemStack[20];
    }

    public void writeModulesToItem() {
        if (this.itemStacks[0] != null && this.itemStacks[0].func_77973_b() instanceof IModular) {
            NBTTagList nbtTagList = new NBTTagList();
            int invSlots = this.func_70302_i_();
            for (int slotNum = 1; slotNum < invSlots && slotNum < 11; ++slotNum) {
                if (this.itemStacks[slotNum] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)slotNum);
                this.itemStacks[slotNum].func_77955_b(tag);
                nbtTagList.func_74742_a((NBTBase)tag);
            }
            NBTTagCompound nbt = this.itemStacks[0].func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if (nbtTagList.func_74745_c() > 0) {
                nbt.func_74782_a("Items", (NBTBase)nbtTagList);
            } else {
                nbt.func_82580_o("Items");
                for (ItemModule.ModuleType mt : ItemModule.ModuleType.values()) {
                    nbt.func_82580_o("Selected_" + mt.getName());
                }
            }
            if (nbt.func_82582_d()) {
                nbt = null;
            }
            this.itemStacks[0].func_77982_d(nbt);
            if (!this.field_145850_b.field_72995_K && NBTHelperTarget.compatibilityTransferTargetData(this.itemStacks[0])) {
                this.clearModuleSlots();
                this.readModulesFromItem();
            }
        }
    }

    public void clearModuleSlots() {
        int invSlots = this.func_70302_i_();
        for (int slotNum = 1; slotNum < invSlots && slotNum < 11; ++slotNum) {
            this.itemStacks[slotNum] = null;
        }
    }

    public void clearModulesFromItem() {
        NBTTagCompound nbt = this.itemStacks[0].func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Items", 9)) {
            return;
        }
        nbt.func_82580_o("Items");
    }

    public void readModulesFromItem() {
        if (this.itemStacks[0] != null && this.itemStacks[0].func_77973_b() instanceof IModular) {
            NBTTagCompound nbt = this.itemStacks[0].func_77978_p();
            if (nbt == null || !nbt.func_150297_b("Items", 9)) {
                return;
            }
            NBTTagList nbtTagList = nbt.func_150295_c("Items", 10);
            int num = nbtTagList.func_74745_c();
            for (int i = 0; i < num; ++i) {
                NBTTagCompound tag = nbtTagList.func_150305_b(i);
                byte slotNum = tag.func_74771_c("Slot");
                if (slotNum < 0 || slotNum >= this.itemStacks.length || slotNum < 1 || slotNum >= 11) continue;
                this.itemStacks[slotNum] = ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }
    }

    @Override
    public void func_70299_a(int slotNum, ItemStack itemStack) {
        if (slotNum == 0 && this.itemStacks[0] != null) {
            this.writeModulesToItem();
            this.clearModuleSlots();
        }
        super.func_70299_a(slotNum, itemStack);
        if (slotNum == 0 && this.itemStacks[0] != null) {
            this.clearModuleSlots();
            this.readModulesFromItem();
        }
    }

    @Override
    public ItemStack func_70298_a(int slotNum, int maxAmount) {
        if (this.itemStacks[slotNum] != null) {
            ItemStack stack;
            if (this.itemStacks[slotNum].field_77994_a >= maxAmount) {
                ItemStack newStack = this.func_70301_a(slotNum).func_77946_l();
                stack = newStack.func_77979_a(maxAmount);
                this.func_70299_a(slotNum, newStack);
                if (this.itemStacks[slotNum].field_77994_a <= 0) {
                    this.func_70299_a(slotNum, null);
                }
            } else {
                stack = this.func_70301_a(slotNum);
                this.func_70299_a(slotNum, null);
            }
            return stack;
        }
        return null;
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack stack) {
        if (slotNum == 0) {
            return stack != null && stack.func_77973_b() instanceof IModular;
        }
        if (slotNum >= 11) {
            return stack != null && stack.func_77973_b() instanceof IModule && !UtilItemModular.moduleTypeEquals(stack, ItemModule.ModuleType.TYPE_INVALID);
        }
        if (slotNum > 0 && slotNum < 11) {
            return false;
        }
        return false;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    @Override
    public boolean func_102007_a(int slotNum, ItemStack itemStack, int side) {
        return false;
    }

    @Override
    public boolean func_102008_b(int slotNum, ItemStack itemStack, int side) {
        return false;
    }

    @Override
    public ContainerToolWorkstation getContainer(InventoryPlayer inventory) {
        return new ContainerToolWorkstation(this, inventory);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilitiesInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiToolWorkstation(this.getContainer(inventoryPlayer), this);
    }
}

