/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.machine.Machine;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BlockEnderUtilitiesTileEntity
extends BlockEnderUtilities
implements ITileEntityProvider {
    public static final byte[] YAW_TO_DIRECTION = new byte[]{2, 5, 3, 4};
    public int blockIndex;

    public BlockEnderUtilitiesTileEntity(int index, String name, float hardness) {
        this(index, name, hardness, Material.field_151576_e);
    }

    public BlockEnderUtilitiesTileEntity(int index, String name, float hardness, Material material) {
        super(index, name, hardness, material);
        this.blockIndex = index;
        Machine.setBlockHardness(this, this.blockIndex);
        Machine.setBlockHarvestLevels(this, this.blockIndex);
    }

    public TileEntity func_149915_a(World world, int meta) {
        Machine machine = Machine.getMachine(this.blockIndex, meta);
        if (machine != null) {
            return machine.createNewTileEntity();
        }
        return null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase livingBase, ItemStack stack) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityEnderUtilities)) {
            return;
        }
        int yaw = MathHelper.func_76128_c((double)((double)(livingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityEnderUtilities teeu = (TileEntityEnderUtilities)te;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("TileEntityData", 10)) {
            teeu.readFromNBTCustom(nbt.func_74775_l("TileEntityData"));
            if (yaw < YAW_TO_DIRECTION.length) {
                teeu.setRotation(YAW_TO_DIRECTION[yaw]);
            }
        } else {
            if (yaw < YAW_TO_DIRECTION.length) {
                teeu.setRotation(YAW_TO_DIRECTION[yaw]);
            }
            if (livingBase instanceof EntityPlayer) {
                teeu.setOwner((EntityPlayer)livingBase);
            }
            if (teeu instanceof TileEntityEnderUtilitiesInventory && stack.func_82837_s()) {
                ((TileEntityEnderUtilitiesInventory)teeu).setInventoryName(stack.func_82833_r());
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        PlayerInteractEvent e = new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, x, y, z, side, world);
        if (MinecraftForge.EVENT_BUS.post((Event)e) || e.getResult() == Event.Result.DENY || e.useBlock == Event.Result.DENY) {
            return false;
        }
        if (!world.field_72995_K) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te == null || !(te instanceof TileEntityEnderUtilities)) {
                return false;
            }
            Machine machine = Machine.getMachine(this.blockIndex, world.func_72805_g(x, y, z));
            if (machine != null && machine.isTileEntityValid(te)) {
                player.openGui((Object)EnderUtilities.instance, 0, world, x, y, z);
            }
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        Machine machine = Machine.getMachine(this.blockIndex, meta);
        if (machine != null) {
            machine.breakBlock(world, x, y, z, block, meta);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return block.getLightValue(world, x, y, z);
        }
        int meta = world.func_72805_g(x, y, z);
        Machine machine = Machine.getMachine(this.blockIndex, meta);
        if (machine != null) {
            return machine.getLightValue(world, x, y, z, block, meta);
        }
        return super.getLightValue(world, x, y, z);
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        Machine.getSubBlocks(this.blockIndex, this, item, tab, list);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        Machine machine = Machine.getMachine(this.blockIndex, world.func_72805_g(x, y, z));
        if (machine != null) {
            machine.randomDisplayTick(world, x, y, z, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        Machine machine = Machine.getMachine(this.blockIndex, meta);
        if (machine != null) {
            return machine.getIcon(side);
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        Machine machine;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityEnderUtilities && (machine = Machine.getMachine(this.blockIndex, blockAccess.func_72805_g(x, y, z))) != null) {
            return machine.getIcon((TileEntityEnderUtilities)te, side);
        }
        return this.func_149691_a(side, blockAccess.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        Machine.registerIcons(this.blockIndex, iconRegister);
    }
}

